/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils;

import com.balugaq.rsceditor.implementation.RSCEditor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlimefunItemUtil {
    private static final List<SlimefunItem> registeredItems = new ArrayList<SlimefunItem>();

    @CanIgnoreReturnValue
    @NotNull
    public static SlimefunItem registerItem(@NotNull SlimefunItem item) {
        item.register((SlimefunAddon)RSCEditor.getInstance());
        return item;
    }

    public static void unregisterItem(SlimefunItem item) {
        if (item instanceof Radioactive) {
            Slimefun.getRegistry().getRadioactiveItems().remove(item);
        }
        if (item instanceof GEOResource) {
            GEOResource geor = (GEOResource)item;
            Slimefun.getRegistry().getGEOResources().remove((Object)geor.getKey());
        }
        Slimefun.getRegistry().getTickerBlocks().remove(item.getId());
        Slimefun.getRegistry().getEnabledSlimefunItems().remove(item);
        Slimefun.getRegistry().getSlimefunItemIds().remove(item.getId());
        Slimefun.getRegistry().getAllSlimefunItems().remove(item);
        Slimefun.getRegistry().getMenuPresets().remove(item.getId());
        Slimefun.getRegistry().getBarteringDrops().remove(item.getItem());
    }

    public static void unregisterAllItems() {
        for (SlimefunItem item : registeredItems) {
            SlimefunItemUtil.unregisterItem(item);
        }
        registeredItems.clear();
        ArrayList items = new ArrayList(Slimefun.getRegistry().getAllSlimefunItems());
        for (SlimefunItem item : items) {
            if (!item.getAddon().getName().equals(RSCEditor.getInstance().getName())) continue;
            SlimefunItemUtil.unregisterItem(item);
        }
    }

    public static void unregisterItemGroups(@NotNull SlimefunAddon addon) {
        HashSet<ItemGroup> itemGroups = new HashSet<ItemGroup>();
        for (ItemGroup itemGroup : Slimefun.getRegistry().getAllItemGroups()) {
            if (!Objects.equals(itemGroup.getAddon(), addon)) continue;
            itemGroups.add(itemGroup);
        }
        for (ItemGroup itemGroup : itemGroups) {
            SlimefunItemUtil.unregisterItemGroup(itemGroup);
        }
    }

    public static void unregisterItemGroup(@Nullable ItemGroup itemGroup) {
        if (itemGroup == null) {
            return;
        }
        Slimefun.getRegistry().getAllItemGroups().remove(itemGroup);
    }

    @Generated
    private SlimefunItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

