/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils;

import com.balugaq.rsceditor.api.objects.types.ItemFlowType;
import com.balugaq.rsceditor.api.objects.types.RainbowType;
import com.balugaq.rsceditor.api.objects.types.SimpleMachineType;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;

public final class TextUtil {
    private static boolean langHelperInit = true;

    @NotNull
    public static String getName(@NotNull SimpleMachineType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SimpleMachineType.ELECTRIC_CRUCIBLE -> "Electric Crucible";
            case SimpleMachineType.ELECTRIC_FURNACE -> "Electric Furnace";
            case SimpleMachineType.ELECTRIC_GOLD_PAN -> "Electric Gold Pan";
            case SimpleMachineType.ELECTRIC_DUST_WASHER -> "Electric Dust Washer";
            case SimpleMachineType.ELECTRIC_ORE_GRINDER -> "Electric Ore Grinder";
            case SimpleMachineType.ELECTRIC_INGOT_FACTORY -> "Electric Ingot Factory";
            case SimpleMachineType.ELECTRIC_INGOT_PULVERIZER -> "Electric Ingot Pulverizer";
            case SimpleMachineType.CHARGING_BENCH -> "Charging Bench";
            case SimpleMachineType.ANIMAL_GROWTH_ACCELERATOR -> "Animal Growth Accelerator";
            case SimpleMachineType.TREE_GROWTH_ACCELERATOR -> "Tree Growth Accelerator";
            case SimpleMachineType.CROP_GROWTH_ACCELERATOR -> "Crop Growth Accelerator";
            case SimpleMachineType.FREEZER -> "Freezer";
            case SimpleMachineType.CARBON_PRESS -> "Carbon Press";
            case SimpleMachineType.ELECTRIC_PRESS -> "Electric Press";
            case SimpleMachineType.ELECTRIC_SMELTERY -> "Electric Smeltery";
            case SimpleMachineType.FOOD_FABRICATOR -> "Food Fabricator";
            case SimpleMachineType.HEATED_PRESSURE_CHAMBER -> "Heated Pressure Chamber";
            case SimpleMachineType.AUTO_ENCHANTER -> "Auto Enchanter";
            case SimpleMachineType.AUTO_DISENCHANTER -> "Auto Disenchanter";
            case SimpleMachineType.BOOK_BINDER -> "Book Binder";
            case SimpleMachineType.AUTO_ANVIL -> "Auto Anvil";
            case SimpleMachineType.AUTO_DRIER -> "Auto Drier";
            case SimpleMachineType.AUTO_BREWER -> "Auto Brewer";
            case SimpleMachineType.REFINERY -> "Refinery";
            case SimpleMachineType.PRODUCE_COLLECTOR -> "Produce Collector";
        };
    }

    @NotNull
    public static String getName(@NotNull Biome biome) {
        String key = biome.translationKey();
        String name = null;
        if (langHelperInit) {
            try {
                name = LegacyComponentSerializer.legacySection().serialize((Component)Component.translatable((String)key));
            }
            catch (Throwable ignored) {
                langHelperInit = false;
            }
        }
        if (name == null) {
            return biome.name();
        }
        return name;
    }

    @NotNull
    public static String getName(@NotNull EnergyNetComponentType type) {
        return switch (type) {
            case EnergyNetComponentType.GENERATOR -> "Generator";
            case EnergyNetComponentType.CAPACITOR -> "Capacitor";
            case EnergyNetComponentType.CONSUMER -> "Consumer";
            case EnergyNetComponentType.CONNECTOR -> "Connector";
            default -> "None";
        };
    }

    @NotNull
    public static String getName(@NotNull ItemFlowType type) {
        return switch (type) {
            case ItemFlowType.INSERT -> "Insert";
            case ItemFlowType.WITHDRAW -> "Withdraw";
            case ItemFlowType.INSERT_AND_WITHDRAW -> "Insert and Withdraw";
            case ItemFlowType.FREE_OUTPUT -> "Free Output";
            default -> "None";
        };
    }

    @NotNull
    public static String getName(@NotNull RainbowType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RainbowType.WOOL -> "Wool";
            case RainbowType.CARPET -> "Carpet";
            case RainbowType.STAINED_GLASS -> "Stained Glass";
            case RainbowType.STAINED_GLASS_PANE -> "Stained Glass Pane";
            case RainbowType.TERRACOTTA -> "Terracotta";
            case RainbowType.GLAZED_TERRACOTTA -> "Glazed Terracotta";
            case RainbowType.CONCRETE -> "Concrete";
            case RainbowType.SHULKER_BOX -> "Shulker Box";
            case RainbowType.CUSTOM -> "Custom";
        };
    }

    @NotNull
    public static String getName(@NotNull Sound sound) {
        String rawName = sound.name().replace("_", " ").toLowerCase();
        return rawName.substring(0, 1).toUpperCase() + rawName.substring(1);
    }

    @Generated
    private TextUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

