/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.api.items;

import com.balugaq.rsceditor.api.base.PlaceholderItem;
import com.balugaq.rsceditor.api.objects.types.Register;
import com.balugaq.rsceditor.implementation.groups.RSCEItemGroups;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.balugaq.rsceditor.utils.PersistentUtil;
import com.balugaq.rsceditor.utils.datatypes.PersistentRegisterType;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisterItem
extends PlaceholderItem {
    public RegisterItem(@NotNull SlimefunItemStack item) {
        super((ItemGroup)RSCEItemGroups.TYPE_GROUP, item);
    }

    @Nullable
    public Register getRegister(ItemStack itemStack) {
        return PersistentUtil.get(itemStack, PersistentRegisterType.TYPE, KeyUtil.REGISTER_KEY);
    }

    public void setRegister(@NotNull ItemStack itemStack, @NotNull Register register) {
        PersistentUtil.set(itemStack, PersistentRegisterType.TYPE, KeyUtil.REGISTER_KEY, register);
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        String id_alias = register.getIdAlias();
        if (id_alias != null) {
            lore.add((CallSite)((Object)("&aFinal Register ID: " + id_alias)));
        }
        boolean lateInit = register.isLateInit();
        lore.add((CallSite)((Object)("&bInit later: " + lateInit)));
        boolean warn = register.isWarn();
        lore.add((CallSite)((Object)("&eWarnings on register: " + warn)));
        boolean unfinished = register.isUnfinished();
        lore.add((CallSite)((Object)("&cIs unfinished: " + unfinished)));
        List<String> conditions = register.getConditions();
        if (conditions != null && !conditions.isEmpty()) {
            for (String string : conditions) {
                lore.add((CallSite)((Object)("&eRegister condition: " + string)));
            }
        }
        ArrayList<String> coloredLore = new ArrayList<String>();
        for (String string : lore) {
            coloredLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setLore(coloredLore);
        itemStack.setItemMeta(itemMeta);
    }
}

