/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils.datatypes;

import com.balugaq.rsceditor.api.objects.types.LinkedMachineRecipe;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.jeff_media.morepersistentdatatypes.DataType;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentLinkedMachineRecipeType
implements PersistentDataType<PersistentDataContainer, LinkedMachineRecipe> {
    public static final PersistentDataType<PersistentDataContainer, LinkedMachineRecipe> TYPE = new PersistentLinkedMachineRecipeType();
    public static final NamespacedKey NAME = KeyUtil.newKey("name");
    public static final NamespacedKey CHOOSE_ONE = KeyUtil.newKey("choose_one");
    public static final NamespacedKey FOR_DISPLAY = KeyUtil.newKey("for_display");
    public static final NamespacedKey HIDE = KeyUtil.newKey("hide");
    public static final NamespacedKey PROCESSING_TIME = KeyUtil.newKey("processing_time");
    public static final NamespacedKey LINKED_INPUTS = KeyUtil.newKey("linked_inputs");
    public static final NamespacedKey LINKED_OUTPUTS = KeyUtil.newKey("linked_outputs");
    public static final NamespacedKey FREE_OUTPUTS = KeyUtil.newKey("free_outputs");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<LinkedMachineRecipe> getComplexType() {
        return LinkedMachineRecipe.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull LinkedMachineRecipe complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(NAME, PersistentDataType.STRING, (Object)complex.getName());
        container.set(CHOOSE_ONE, DataType.BOOLEAN, (Object)complex.isChooseOne());
        container.set(FOR_DISPLAY, DataType.BOOLEAN, (Object)complex.isForDisplay());
        container.set(HIDE, DataType.BOOLEAN, (Object)complex.isHide());
        container.set(PROCESSING_TIME, PersistentDataType.INTEGER, (Object)complex.getProcessingTime());
        Map<Integer, ItemStack> inputs = complex.getLinkedInputs();
        ItemStack[] inputArray = new ItemStack[inputs.size() * 2];
        int index = 0;
        for (Map.Entry<Integer, ItemStack> entry : inputs.entrySet()) {
            inputArray[index] = new ItemStack(Material.BARRIER, entry.getKey().intValue());
            inputArray[index + 1] = entry.getValue();
            index += 2;
        }
        container.set(LINKED_INPUTS, DataType.ITEM_STACK_ARRAY, (Object)inputArray);
        Map<Integer, ItemStack> outputs = complex.getLinkedOutputs();
        ItemStack[] outputArray = new ItemStack[outputs.size() * 2];
        index = 0;
        for (Map.Entry<Integer, ItemStack> entry : outputs.entrySet()) {
            outputArray[index] = new ItemStack(Material.BARRIER, entry.getKey().intValue());
            outputArray[index + 1] = entry.getValue();
            index += 2;
        }
        container.set(LINKED_OUTPUTS, DataType.ITEM_STACK_ARRAY, (Object)outputArray);
        container.set(FREE_OUTPUTS, DataType.ITEM_STACK_ARRAY, (Object)complex.getFreeOutputs());
        return container;
    }

    @Nonnull
    public LinkedMachineRecipe fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        String name = (String)primitive.getOrDefault(NAME, PersistentDataType.STRING, (Object)"");
        boolean chooseOne = (Boolean)primitive.getOrDefault(CHOOSE_ONE, DataType.BOOLEAN, (Object)false);
        boolean forDisplay = (Boolean)primitive.getOrDefault(FOR_DISPLAY, DataType.BOOLEAN, (Object)false);
        boolean hide = (Boolean)primitive.getOrDefault(HIDE, DataType.BOOLEAN, (Object)false);
        int processingTime = (Integer)primitive.getOrDefault(PROCESSING_TIME, PersistentDataType.INTEGER, (Object)0);
        ItemStack[] inputArray = (ItemStack[])primitive.get(LINKED_INPUTS, DataType.ITEM_STACK_ARRAY);
        if (inputArray == null) {
            return new LinkedMachineRecipe(name, chooseOne, forDisplay, hide, processingTime, new HashMap<Integer, ItemStack>(), new HashMap<Integer, ItemStack>(), new ItemStack[0]);
        }
        ItemStack[] outputArray = (ItemStack[])primitive.get(LINKED_OUTPUTS, DataType.ITEM_STACK_ARRAY);
        if (outputArray == null) {
            return new LinkedMachineRecipe(name, chooseOne, forDisplay, hide, processingTime, new HashMap<Integer, ItemStack>(), new HashMap<Integer, ItemStack>(), new ItemStack[0]);
        }
        ItemStack[] freeOutputArray = (ItemStack[])primitive.get(FREE_OUTPUTS, DataType.ITEM_STACK_ARRAY);
        HashMap<Integer, ItemStack> inputs = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inputArray.length; i += 2) {
            inputs.put(inputArray[i].getAmount(), inputArray[i + 1]);
        }
        HashMap<Integer, ItemStack> outputs = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < outputArray.length; i += 2) {
            outputs.put(outputArray[i].getAmount(), outputArray[i + 1]);
        }
        return new LinkedMachineRecipe(name, chooseOne, forDisplay, hide, processingTime, inputs, outputs, freeOutputArray);
    }
}

