/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.implementation;

import com.balugaq.rsceditor.core.command.RSCECommands;
import com.balugaq.rsceditor.core.listeners.ItemEditListener;
import com.balugaq.rsceditor.core.managers.ConfigManager;
import com.balugaq.rsceditor.implementation.groups.GroupSetup;
import com.balugaq.rsceditor.implementation.items.BiomeItems;
import com.balugaq.rsceditor.implementation.items.ItemGroupItems;
import com.balugaq.rsceditor.implementation.items.MachineSetup;
import com.balugaq.rsceditor.implementation.items.RecipeTypeItems;
import com.balugaq.rsceditor.implementation.items.SoundTypeItems;
import com.balugaq.rsceditor.implementation.items.ToolSetup;
import com.balugaq.rsceditor.implementation.items.TypeItems;
import com.balugaq.rsceditor.utils.SlimefunItemUtil;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class RSCEditor
extends JavaPlugin
implements SlimefunAddon {
    private static RSCEditor instance;
    private String username;
    private String repo;
    private String branch;
    private ConfigManager configManager;

    public static RSCEditor getInstance() {
        return instance;
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.configManager = new ConfigManager(this);
        this.username = "balugaq";
        this.repo = "RSCEditor";
        this.branch = "master";
        GroupSetup.register();
        TypeItems.register();
        MachineSetup.register();
        RecipeTypeItems.register();
        ItemGroupItems.register();
        BiomeItems.register();
        SoundTypeItems.register();
        ToolSetup.register();
        this.getLogger().info("Trying to start updater...");
        PluginCommand command = this.getCommand("rsceditor");
        if (command != null) {
            command.setExecutor((CommandExecutor)new RSCECommands());
        } else {
            this.getLogger().warning("Failed to register command 'rsceditor'.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new ItemEditListener(), (Plugin)this);
        this.getLogger().info("RSCEditor has been enabled.");
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    public void onDisable() {
        SlimefunItemUtil.unregisterAllItems();
        SlimefunItemUtil.unregisterItemGroups(this);
        this.getLogger().info("RSCEditor has been disabled.");
    }

    @NotNull
    public JavaPlugin getJavaPlugin() {
        return this;
    }

    public String getBugTrackerURL() {
        return "https://github.com/balugaq/RSCEditor/issues";
    }

    public void tryUpdate() {
        try {
            if (this.configManager.isAutoUpdate() && this.getDescription().getVersion().startsWith("Build")) {
                BlobBuildUpdater u = new BlobBuildUpdater((Plugin)this, this.getFile(), "SlimefunReloadingProject/RSCEditor-EN");
                u.start();
            }
        }
        catch (NoClassDefFoundError | NullPointerException | UnsupportedClassVersionError e) {
            this.getLogger().info("Failed to auto update: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isDebug() {
        return this.configManager.isDebug();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getRepo() {
        return this.repo;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

