/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.api.items;

import com.balugaq.rsceditor.api.base.BaseTypeItem;
import com.balugaq.rsceditor.api.objects.types.PlaceHolderType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleTypeItem
extends BaseTypeItem<Double> {
    public DoubleTypeItem(@NotNull SlimefunItemStack item) {
        super(item, PlaceHolderType.DOUBLE_PLACEHOLDER);
    }

    @Override
    public void setContent(@Nullable ItemStack itemStack, @NotNull String content) {
        if (itemStack == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if ("!cancel".equals(content)) {
            return;
        }
        try {
            double value = Double.parseDouble(content);
            itemMeta.getPersistentDataContainer().set(CONTENT_KEY, PersistentDataType.DOUBLE, (Object)value);
            ArrayList<CallSite> lore = new ArrayList<CallSite>(itemMeta.getLore());
            lore.add((CallSite)((Object)("\u00a7aContent: " + content)));
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public Double getContent(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        Double data = (Double)itemMeta.getPersistentDataContainer().get(CONTENT_KEY, PersistentDataType.DOUBLE);
        return data == null ? 0.0 : data;
    }
}

