/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils.datatypes;

import com.balugaq.rsceditor.api.objects.types.Register;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.jeff_media.morepersistentdatatypes.DataType;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentRegisterType
implements PersistentDataType<PersistentDataContainer, Register> {
    public static final PersistentDataType<PersistentDataContainer, Register> TYPE = new PersistentRegisterType();
    private static final NamespacedKey ID_ALIAS = KeyUtil.newKey("id_alias");
    private static final NamespacedKey LATE_INIT = KeyUtil.newKey("late_init");
    private static final NamespacedKey WARN = KeyUtil.newKey("warn");
    private static final NamespacedKey UNFINISHED = KeyUtil.newKey("unfinished");
    private static final NamespacedKey CONDITIONS = KeyUtil.newKey("conditions");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<Register> getComplexType() {
        return Register.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull Register complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        String id_alias = complex.getIdAlias();
        if (id_alias != null) {
            container.set(ID_ALIAS, PersistentDataType.STRING, (Object)id_alias);
        }
        boolean late_init = complex.isLateInit();
        container.set(LATE_INIT, DataType.BOOLEAN, (Object)late_init);
        boolean warn = complex.isWarn();
        container.set(WARN, DataType.BOOLEAN, (Object)warn);
        boolean unfinished = complex.isUnfinished();
        container.set(UNFINISHED, DataType.BOOLEAN, (Object)unfinished);
        List<String> conditions = complex.getConditions();
        if (conditions != null && !conditions.isEmpty()) {
            String[] conditionArray = conditions.toArray(new String[0]);
            container.set(CONDITIONS, DataType.STRING_ARRAY, (Object)conditionArray);
        }
        return container;
    }

    @Nonnull
    public Register fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        String id_alias = (String)primitive.get(ID_ALIAS, PersistentDataType.STRING);
        boolean late_init = (Boolean)primitive.getOrDefault(LATE_INIT, DataType.BOOLEAN, (Object)false);
        boolean warn = (Boolean)primitive.getOrDefault(WARN, DataType.BOOLEAN, (Object)false);
        boolean unfinished = (Boolean)primitive.getOrDefault(UNFINISHED, DataType.BOOLEAN, (Object)false);
        String[] conditions = (String[])primitive.get(CONDITIONS, DataType.STRING_ARRAY);
        List<String> conditionList = conditions != null ? List.of(conditions) : null;
        return new Register(id_alias, late_init, warn, unfinished, conditionList);
    }
}

