/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.api.items;

import com.balugaq.rsceditor.api.base.BaseTypeItem;
import com.balugaq.rsceditor.api.objects.types.PlaceHolderType;
import com.jeff_media.morepersistentdatatypes.DataType;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanTypeItem
extends BaseTypeItem<Boolean> {
    public BooleanTypeItem(@NotNull SlimefunItemStack item) {
        super(item, PlaceHolderType.BOOLEAN_PLACEHOLDER);
    }

    @Override
    public void setContent(@Nullable ItemStack itemStack, String content) {
        if (itemStack == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        if ("!cancel".equals(content)) {
            return;
        }
        try {
            boolean value = Boolean.parseBoolean(content);
            itemMeta.getPersistentDataContainer().set(CONTENT_KEY, DataType.BOOLEAN, (Object)value);
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a7aContent: " + value)));
            itemMeta.setLore(lore);
            itemStack.setItemMeta(itemMeta);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public Boolean getContent(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        Boolean data = (Boolean)itemMeta.getPersistentDataContainer().get(CONTENT_KEY, DataType.BOOLEAN);
        return data != null && data != false;
    }
}

