/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.utils.datatypes;

import com.balugaq.rsceditor.api.objects.types.MachineRecipe;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.jeff_media.morepersistentdatatypes.DataType;
import javax.annotation.Nonnull;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PersistentMachineRecipeType
implements PersistentDataType<PersistentDataContainer, MachineRecipe> {
    public static final PersistentDataType<PersistentDataContainer, MachineRecipe> TYPE = new PersistentMachineRecipeType();
    public static final NamespacedKey NAME = KeyUtil.newKey("name");
    public static final NamespacedKey CHOOSE_ONE = KeyUtil.newKey("choose_one");
    public static final NamespacedKey FOR_DISPLAY = KeyUtil.newKey("for_display");
    public static final NamespacedKey HIDE = KeyUtil.newKey("hide");
    public static final NamespacedKey PROCESSING_TIME = KeyUtil.newKey("processing_time");
    public static final NamespacedKey INPUTS = KeyUtil.newKey("inputs");
    public static final NamespacedKey OUTPUTS = KeyUtil.newKey("outputs");

    @Nonnull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Nonnull
    public Class<MachineRecipe> getComplexType() {
        return MachineRecipe.class;
    }

    @Nonnull
    public PersistentDataContainer toPrimitive(@Nonnull MachineRecipe complex, @Nonnull PersistentDataAdapterContext context) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(NAME, PersistentDataType.STRING, (Object)complex.getName());
        container.set(CHOOSE_ONE, DataType.BOOLEAN, (Object)complex.isChooseOne());
        container.set(FOR_DISPLAY, DataType.BOOLEAN, (Object)complex.isForDisplay());
        container.set(HIDE, DataType.BOOLEAN, (Object)complex.isHide());
        container.set(PROCESSING_TIME, DataType.INTEGER, (Object)complex.getProcessingTime());
        container.set(INPUTS, DataType.ITEM_STACK_ARRAY, (Object)complex.getInputs());
        container.set(OUTPUTS, DataType.ITEM_STACK_ARRAY, (Object)complex.getOutputs());
        return container;
    }

    @Nonnull
    public MachineRecipe fromPrimitive(@Nonnull PersistentDataContainer primitive, @Nonnull PersistentDataAdapterContext context) {
        String name = (String)primitive.getOrDefault(NAME, PersistentDataType.STRING, (Object)"");
        boolean chooseOne = (Boolean)primitive.getOrDefault(CHOOSE_ONE, DataType.BOOLEAN, (Object)false);
        boolean forDisplay = (Boolean)primitive.getOrDefault(FOR_DISPLAY, DataType.BOOLEAN, (Object)false);
        boolean hide = (Boolean)primitive.getOrDefault(HIDE, DataType.BOOLEAN, (Object)false);
        int processingTime = (Integer)primitive.getOrDefault(PROCESSING_TIME, DataType.INTEGER, (Object)0);
        ItemStack[] inputs = (ItemStack[])primitive.get(INPUTS, DataType.ITEM_STACK_ARRAY);
        if (inputs == null) {
            return new MachineRecipe(name, chooseOne, forDisplay, hide, processingTime, new ItemStack[0], new ItemStack[0]);
        }
        ItemStack[] outputs = (ItemStack[])primitive.get(OUTPUTS, DataType.ITEM_STACK_ARRAY);
        if (outputs == null) {
            return new MachineRecipe(name, chooseOne, forDisplay, hide, processingTime, inputs, new ItemStack[0]);
        }
        return new MachineRecipe(name, chooseOne, forDisplay, hide, processingTime, inputs, outputs);
    }
}

