/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.implementation.items.tools;

import com.balugaq.rsceditor.api.base.AbstractTool;
import com.balugaq.rsceditor.utils.KeyUtil;
import com.balugaq.rsceditor.utils.PersistentUtil;
import com.jeff_media.morepersistentdatatypes.DataType;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class MenuCopier
extends AbstractTool {
    public MenuCopier(@NotNull SlimefunItemStack item) {
        super(item);
    }

    public static void saveMenu0(@NotNull ItemStack tool, @NotNull BlockMenu menu) {
        PersistentUtil.set(tool, DataType.ITEM_STACK_ARRAY, KeyUtil.MENU_CONTENTS, (ItemStack[])menu.getContents().clone());
        ItemMeta meta = tool.getItemMeta();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)tool);
        if (!(slimefunItem instanceof MenuCopier)) {
            return;
        }
        MenuCopier mc = (MenuCopier)slimefunItem;
        ArrayList<String> lore = new ArrayList<String>(mc.getItem().getLore());
        Location location = menu.getLocation();
        lore.add(MenuCopier.compile("&aSaved: " + menu.getPreset().getTitle()));
        lore.add(MenuCopier.compile("&aLocation: " + location.getWorld().getName() + ";" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ()));
        lore.add(MenuCopier.compile("&aSlimefun Item ID: " + menu.getPreset().getID()));
        meta.setLore(lore);
        tool.setItemMeta(meta);
    }

    public static void pasteMenu0(@NotNull ItemStack tool, @NotNull BlockMenu menu) {
        ItemStack[] contents = PersistentUtil.get(tool, DataType.ITEM_STACK_ARRAY, KeyUtil.MENU_CONTENTS);
        if (contents == null) {
            return;
        }
        int size = menu.getPreset().getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null) {
                menu.replaceExistingItem(i, null);
                continue;
            }
            menu.replaceExistingItem(i, itemStack.clone());
        }
    }

    public static String compile(String str) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)str);
    }

    @Override
    public void toolUse(@NotNull BlockBreakEvent event, @NotNull ItemStack tool, int fortune, @NotNull List<ItemStack> drops) {
    }

    @Override
    public void rightClick(@NotNull PlayerRightClickEvent event) {
        event.cancel();
        Player player = event.getPlayer();
        Optional optional = event.getClickedBlock();
        if (player.isSneaking()) {
            if (optional.isPresent()) {
                ItemStack tool = event.getItem();
                if (tool.getType() == Material.AIR) {
                    player.sendMessage("\u00a7cYou must hold a tool in your hand to copy or paste a menu.");
                    return;
                }
                Block block = (Block)optional.get();
                Location location = block.getLocation();
                BlockMenu menu = BlockStorage.getInventory((Location)location);
                if (menu == null) {
                    player.sendMessage("\u00a7cThere is no menu on this block.");
                    return;
                }
                ItemStack[] contents = menu.getContents();
                if (contents == null) {
                    player.sendMessage("\u00a7cThe menu is the block is empty.");
                    return;
                }
                MenuCopier.saveMenu0(tool, menu);
                player.sendMessage("\u00a7aCopied menu contents successfully.");
            }
        } else {
            ItemStack[] contents = PersistentUtil.get(event.getItem(), DataType.ITEM_STACK_ARRAY, KeyUtil.MENU_CONTENTS);
            if (contents == null) {
                player.sendMessage("\u00a7cYou have not copied a menu yet.");
                return;
            }
            if (optional.isPresent()) {
                Block block = (Block)optional.get();
                Location location = block.getLocation();
                BlockMenu menu = BlockStorage.getInventory((Location)location);
                if (menu == null) {
                    player.sendMessage("\u00a7cThere is no menu on this block, cannot paste.");
                    return;
                }
                MenuCopier.pasteMenu0(event.getItem(), menu);
                player.sendMessage("\u00a7aPasted menu contents successfully.");
            } else {
                player.sendMessage("\u00a7cYou must right-click on a block to paste the menu contents.");
            }
        }
    }
}

