/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.rsceditor.implementation.items.machines.builder;

import com.balugaq.rsceditor.api.base.AbstractContainer;
import com.balugaq.rsceditor.api.objects.MenuMatrix;
import com.balugaq.rsceditor.utils.ClipboardUtil;
import com.balugaq.rsceditor.utils.Icons;
import com.balugaq.rsceditor.utils.ItemUtil;
import com.balugaq.rsceditor.utils.YamlWriter;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class MultiBlockRecipeBuilder
extends AbstractContainer {
    private static final MenuMatrix matrix = new MenuMatrix().addLine("IIIIIIIII").addLine("IIIIIIIII").addLine("IIIIIIIII").addLine("IIIIIIIII").addLine("IIIIIIIBB").addLine("IIIIIIIBG").addItem("G", Icons.build_multi_block_recipe).addItem("B", Icons.white_background);

    public MultiBlockRecipeBuilder(@NotNull SlimefunItemStack item) {
        super(item);
    }

    @Override
    @NotNull
    public BlockMenuPreset setBlockMenuPreset() {
        return new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                matrix.build(this);
            }

            public void newInstance(@NotNull BlockMenu menu, @NotNull Block b) {
                menu.addMenuClickHandler(matrix.getChar("G"), (p, s, i, a) -> {
                    YamlWriter writer = new YamlWriter();
                    writer.setRoot("recipes");
                    Pair<Boolean, List<ItemStack>> itemStacks = ItemUtil.isItems(menu, matrix, "I");
                    if (((Boolean)itemStacks.getFirstValue()).booleanValue()) {
                        List itemStackList = (List)itemStacks.getSecondValue();
                        for (ItemStack itemStack : itemStackList) {
                            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
                            if (slimefunItem == null) {
                                Recipe[] recipes = Slimefun.getMinecraftRecipeService().getRecipesFor(itemStack);
                                if (recipes.length <= 0) continue;
                                Recipe availableRecipe = recipes[0];
                                if (availableRecipe instanceof ShapedRecipe) {
                                    ShapedRecipe sr = (ShapedRecipe)availableRecipe;
                                    String[] shape = sr.getShape();
                                    Map choiceMap = sr.getChoiceMap();
                                    ArrayList<ItemStack> recipe = new ArrayList<ItemStack>();
                                    for (String row : shape) {
                                        for (char c : row.toCharArray()) {
                                            RecipeChoice choice = (RecipeChoice)choiceMap.get(Character.valueOf(c));
                                            if (choice == null) {
                                                recipe.add(null);
                                                continue;
                                            }
                                            recipe.add(choice.getItemStack());
                                        }
                                    }
                                    for (int m = 0; m < recipe.size(); ++m) {
                                        ItemStack item = (ItemStack)recipe.get(m);
                                        if (item == null || item.getType() == Material.AIR) continue;
                                        writer.set(item.getType().name().toLowerCase() + ".input." + m, item.clone(), false);
                                    }
                                    continue;
                                }
                                if (!(availableRecipe instanceof ShapelessRecipe)) continue;
                                ShapelessRecipe sr = (ShapelessRecipe)availableRecipe;
                                List choiceList = sr.getChoiceList();
                                for (int m = 0; m < choiceList.size(); ++m) {
                                    ItemStack item;
                                    RecipeChoice choice = (RecipeChoice)choiceList.get(m);
                                    if (choice == null || (item = choice.getItemStack()) == null || item.getType() == Material.AIR) continue;
                                    writer.set(item.getType().name().toLowerCase() + ".input." + m, item.clone(), false);
                                }
                                continue;
                            }
                            String id = slimefunItem.getId();
                            ItemStack item = slimefunItem.getRecipeOutput();
                            ItemStack[] recipe = slimefunItem.getRecipe();
                            if (recipe == null) continue;
                            for (int k = 0; k < recipe.length; ++k) {
                                ItemStack input = recipe[k];
                                if (input == null || input.getType() == Material.AIR) continue;
                                writer.set(id.toLowerCase() + ".input." + (k + 1), input.clone(), false);
                            }
                            writer.set(id.toLowerCase() + ".output", item.clone(), false);
                        }
                    } else {
                        p.sendMessage("\u00a7cYou need to select at least one item in the grid");
                        return false;
                    }
                    ClipboardUtil.send(p, writer.toString());
                    p.sendMessage("\u00a7aEdited successfully!");
                    return false;
                });
            }

            public boolean canOpen(@NotNull Block block, @NotNull Player player) {
                return player.isOp();
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }
        };
    }
}

