/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.objects;

import cz.vitekform.rPGCore.RPGCore;
import cz.vitekform.rPGCore.objects.RPGItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class RPGEntity {
    public String visibleName = "";
    public int level = 0;
    public double maxHealth = 0.0;
    public double health = 0.0;
    public double attack = 0.0;
    public int defense = 0;
    public double speed = 0.0;
    public int experienceAfterDefeat = 0;
    public List<RPGItem> drops = new ArrayList<RPGItem>();
    public boolean isBoss = false;
    public boolean isFriendly = false;
    public boolean hasVisibleName = false;
    public EntityType entityType;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private ItemStack mainHand;
    private ItemStack offHand;
    private UUID entityUUID;
    private BossBar bossBar;

    public List<ItemStack> dropsAsItemStacks() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (RPGItem drop : this.drops) {
            itemStacks.add(drop.build());
        }
        return itemStacks;
    }

    public static boolean isRPGEntity(LivingEntity e) {
        return RPGCore.entityStorage.containsKey(e.getUniqueId());
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
        this.updateEquipment();
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
        this.updateEquipment();
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
        this.updateEquipment();
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
        this.updateEquipment();
    }

    public void setMainHand(ItemStack mainHand) {
        this.mainHand = mainHand;
        this.updateEquipment();
    }

    public void setOffHand(ItemStack offHand) {
        this.offHand = offHand;
        this.updateEquipment();
    }

    public Entity spawnIn(Location location) {
        if (this.entityType == null) {
            throw new IllegalStateException("Entity type must be set before spawning");
        }
        World world = location.getWorld();
        Entity entity = world.spawnEntity(location, this.entityType);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.hasVisibleName) {
                livingEntity.customName((Component)Component.text((String)this.visibleName));
                livingEntity.setCustomNameVisible(true);
            }
            this.entityUUID = entity.getUniqueId();
            this.updateEquipment();
            RPGCore.entityStorage.put(entity.getUniqueId(), this);
            if (this.isBoss) {
                this.showBossbar();
            }
        }
        return entity;
    }

    public void setHostile(boolean hostile) {
        this.isFriendly = !hostile;
    }

    public void teleport(Location location) {
        Entity entity;
        if (this.entityUUID != null && (entity = Bukkit.getEntity((UUID)this.entityUUID)) != null) {
            entity.teleport(location);
        }
    }

    public void showBossbar() {
        if (!this.isBoss || this.entityUUID == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)this.entityUUID);
        if (entity == null) {
            return;
        }
        double healthPercentage = this.health / this.maxHealth;
        if (this.bossBar == null) {
            this.bossBar = BossBar.bossBar((Component)Component.text((String)(this.visibleName + " [Lvl " + this.level + "]")), (float)((float)healthPercentage), (BossBar.Color)BossBar.Color.RED, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        } else {
            this.bossBar.name((Component)Component.text((String)(this.visibleName + " [Lvl " + this.level + "]")));
            this.bossBar.progress((float)healthPercentage);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getWorld().equals((Object)entity.getWorld()) && player.getLocation().distance(entity.getLocation()) < 50.0) {
                player.showBossBar(this.bossBar);
                continue;
            }
            player.hideBossBar(this.bossBar);
        }
    }

    public void despawn() {
        Entity entity;
        if (this.entityUUID != null && (entity = Bukkit.getEntity((UUID)this.entityUUID)) != null) {
            if (this.bossBar != null) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.hideBossBar(this.bossBar);
                }
            }
            RPGCore.entityStorage.remove(this.entityUUID);
            entity.remove();
        }
    }

    private void updateEquipment() {
        LivingEntity livingEntity;
        EntityEquipment equipment;
        if (this.entityUUID == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)this.entityUUID);
        if (entity instanceof LivingEntity && (equipment = (livingEntity = (LivingEntity)entity).getEquipment()) != null) {
            if (this.helmet != null) {
                equipment.setHelmet(this.helmet);
            }
            if (this.chestplate != null) {
                equipment.setChestplate(this.chestplate);
            }
            if (this.leggings != null) {
                equipment.setLeggings(this.leggings);
            }
            if (this.boots != null) {
                equipment.setBoots(this.boots);
            }
            if (this.mainHand != null) {
                equipment.setItemInMainHand(this.mainHand);
            }
            if (this.offHand != null) {
                equipment.setItemInOffHand(this.offHand);
            }
            equipment.setHelmetDropChance(0.0f);
            equipment.setChestplateDropChance(0.0f);
            equipment.setLeggingsDropChance(0.0f);
            equipment.setBootsDropChance(0.0f);
            equipment.setItemInMainHandDropChance(0.0f);
            equipment.setItemInOffHandDropChance(0.0f);
        }
    }
}

