/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.objects;

import cz.vitekform.rPGCore.RPGCore;
import cz.vitekform.rPGCore.objects.RPGClass;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Equippable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class RPGItem {
    public Component itemName = Component.newline();
    public List<Component> itemLore = new ArrayList<Component>();
    public int reqLevel = 0;
    public RPGClass reqClass = RPGClass.ANY;
    public double attack = 0.0;
    public double attackSpeed = 0.0;
    public int defense = 0;
    public int health = 0;
    public double speed = 0.0;
    public int mana;
    public double critChance = 0.0;
    public int max_durability = -1;
    public int durability = -1;
    public int slotReq = -1;
    public Material material = Material.PAPER;
    public String texturePath = null;
    public String modelPath = null;
    public String modelType = null;
    public String customModelKey = null;
    public String armorTexturePath = null;
    public String armorLayerType = null;
    public String equipmentModelKey = null;

    public ItemStack build() {
        if (this.max_durability > 0 && this.durability == -1) {
            this.durability = this.max_durability;
        }
        ItemStack i = new ItemStack(this.material);
        ItemMeta im = i.getItemMeta();
        this.itemName = RPGCore.fancyText(List.of(this.itemName.decorations(Map.of(TextDecoration.BOLD, TextDecoration.State.TRUE, TextDecoration.ITALIC, TextDecoration.State.FALSE)))).getFirst();
        im.displayName(this.itemName);
        this.constructLore();
        im.lore(this.itemLore);
        NamespacedKey key_class = new NamespacedKey("rpgcore", "rpg_item_class");
        NamespacedKey key_level = new NamespacedKey("rpgcore", "rpg_item_level");
        NamespacedKey key_attack = new NamespacedKey("rpgcore", "rpg_item_attack");
        NamespacedKey key_attack_speed = new NamespacedKey("rpgcore", "rpg_item_attack_speed");
        NamespacedKey key_defense = new NamespacedKey("rpgcore", "rpg_item_defense");
        NamespacedKey key_health = new NamespacedKey("rpgcore", "rpg_item_health");
        NamespacedKey key_speed = new NamespacedKey("rpgcore", "rpg_item_speed");
        NamespacedKey key_mana = new NamespacedKey("rpgcore", "rpg_item_mana");
        NamespacedKey key_slot = new NamespacedKey("rpgcore", "rpg_item_slot");
        NamespacedKey key_crit_chance = new NamespacedKey("rpgcore", "rpg_item_crit_chance");
        PersistentDataContainer pdc = im.getPersistentDataContainer();
        pdc.set(key_class, PersistentDataType.STRING, (Object)this.reqClass.name());
        pdc.set(key_level, PersistentDataType.INTEGER, (Object)this.reqLevel);
        pdc.set(key_attack, PersistentDataType.DOUBLE, (Object)this.attack);
        pdc.set(key_attack_speed, PersistentDataType.DOUBLE, (Object)this.attackSpeed);
        pdc.set(key_defense, PersistentDataType.INTEGER, (Object)this.defense);
        pdc.set(key_health, PersistentDataType.INTEGER, (Object)this.health);
        pdc.set(key_speed, PersistentDataType.DOUBLE, (Object)this.speed);
        pdc.set(key_mana, PersistentDataType.INTEGER, (Object)this.mana);
        pdc.set(key_slot, PersistentDataType.INTEGER, (Object)this.slotReq);
        pdc.set(key_crit_chance, PersistentDataType.DOUBLE, (Object)this.critChance);
        im.setUnbreakable(true);
        if (this.customModelKey != null && !this.customModelKey.isEmpty()) {
            try {
                NamespacedKey modelKey = NamespacedKey.fromString((String)this.customModelKey);
                if (modelKey != null) {
                    im.setItemModel(modelKey);
                }
            }
            catch (IllegalArgumentException modelKey) {
                // empty catch block
            }
        }
        i.setItemMeta(im);
        if (this.equipmentModelKey != null && !this.equipmentModelKey.isEmpty()) {
            try {
                Key assetKey = Key.key((String)this.equipmentModelKey);
                EquipmentSlot slot = this.getEquipmentSlotFromSlotReq();
                if (slot != null) {
                    Equippable equippable = (Equippable)Equippable.equippable((EquipmentSlot)slot).assetId(assetKey).build();
                    i.setData(DataComponentTypes.EQUIPPABLE, (Object)equippable);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return i;
    }

    public ItemStack build(int amount) {
        ItemStack itemStack = this.build();
        itemStack.setAmount(amount);
        return itemStack;
    }

    private EquipmentSlot getEquipmentSlotFromSlotReq() {
        return switch (this.slotReq) {
            case 0 -> EquipmentSlot.HAND;
            case 1 -> EquipmentSlot.HEAD;
            case 2 -> EquipmentSlot.CHEST;
            case 3 -> EquipmentSlot.LEGS;
            case 4 -> EquipmentSlot.FEET;
            case 5 -> EquipmentSlot.OFF_HAND;
            default -> null;
        };
    }

    private String getNormalName(RPGClass rpgClass) {
        return rpgClass.toString().substring(0, 1).toUpperCase() + rpgClass.toString().substring(1).toLowerCase();
    }

    private void constructLore() {
        ArrayList<Component> lore = new ArrayList<Component>(this.itemLore != null ? this.itemLore : new ArrayList());
        if (this.reqClass != RPGClass.ANY) {
            lore.add(((TextComponent)Component.text((String)("Class: " + this.getNormalName(this.reqClass))).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
        }
        if (this.reqLevel > 0) {
            lore.add(((TextComponent)Component.text((String)("Required Level: " + this.reqLevel)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
        }
        if (this.attack > 0.0) {
            lore.add(((TextComponent)Component.text((String)("Attack: " + this.attack)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.GRAY));
        }
        if (this.attackSpeed > 0.0) {
            lore.add(((TextComponent)Component.text((String)("Attack Speed: " + this.attackSpeed)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.GRAY));
        }
        if (this.critChance > 0.0) {
            lore.add(((TextComponent)Component.text((String)("Critical Chance: " + this.critChance + "%")).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.LIGHT_PURPLE));
        }
        if (this.defense > 0) {
            lore.add(((TextComponent)Component.text((String)("Defense: " + this.defense)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.GREEN));
        }
        if (this.health > 0) {
            lore.add(((TextComponent)Component.text((String)("Health: " + this.health)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.RED));
        }
        if (this.speed > 0.0) {
            lore.add(((TextComponent)Component.text((String)("Speed: " + this.speed)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
        }
        if (this.mana > 0) {
            lore.add(((TextComponent)Component.text((String)("Mana: " + this.mana)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.AQUA));
        }
        if (this.max_durability > 0) {
            lore.add(((TextComponent)Component.text((String)("Durability: " + this.durability + "/" + this.max_durability)).decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.GRAY));
        }
        if (this.slotReq != -1) {
            if (this.slotReq == 0) {
                lore.add(((TextComponent)Component.text((String)"Slot: Main Hand").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            } else if (this.slotReq == 1) {
                lore.add(((TextComponent)Component.text((String)"Slot: Helmet").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            } else if (this.slotReq == 2) {
                lore.add(((TextComponent)Component.text((String)"Slot: Chestplate").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            } else if (this.slotReq == 3) {
                lore.add(((TextComponent)Component.text((String)"Slot: Leggings").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            } else if (this.slotReq == 4) {
                lore.add(((TextComponent)Component.text((String)"Slot: Boots").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            } else if (this.slotReq == -5) {
                lore.add(((TextComponent)Component.text((String)"Slot: Offhand").decoration(TextDecoration.ITALIC, false)).color((TextColor)NamedTextColor.WHITE));
            }
        }
        this.itemLore = RPGCore.fancyText(lore);
    }

    public void chipDurabilityAway(ItemStack itemStack, int amount) {
        PersistentDataContainer pdc = itemStack.getItemMeta().getPersistentDataContainer();
        if (this.max_durability <= 0) {
            return;
        }
        this.durability -= amount;
        if (this.durability <= 0) {
            itemStack.setAmount(0);
            return;
        }
        pdc.set(new NamespacedKey("rpgcore", "rpg_item_durability"), PersistentDataType.INTEGER, (Object)this.durability);
        this.constructLore();
        itemStack.getItemMeta().lore(this.itemLore);
    }
}

