/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.objects;

import cz.vitekform.rPGCore.ItemDictionary;
import cz.vitekform.rPGCore.objects.RPGClass;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class RPGItem {
    public String itemName;
    public List<String> itemLore;
    public int reqLevel;
    public RPGClass reqClass;
    public int attack;
    public int attackSpeed;
    public int defense;
    public int health;
    public int speed;
    public int mana;
    public Material material;
    public String id;

    public RPGItem(String itemName, int reqLevel, RPGClass reqClass, int attack, int attackSpeed, int defense, int health, int speed) {
        this.itemName = itemName;
        this.itemLore = new ArrayList<String>();
        this.reqLevel = reqLevel;
        this.reqClass = reqClass;
        this.attack = attack;
        this.attackSpeed = attackSpeed;
        this.defense = defense;
        this.health = health;
        this.speed = speed;
        this.material = Material.PAPER;
        this.generateId();
    }

    public RPGItem() {
        this.itemName = "";
        this.itemLore = new ArrayList<String>();
        this.reqLevel = 0;
        this.reqClass = RPGClass.ANY;
        this.attack = 0;
        this.attackSpeed = 0;
        this.defense = 0;
        this.health = 0;
        this.speed = 0;
        this.material = Material.PAPER;
        this.generateId();
    }

    public ItemStack build() {
        ItemStack i = new ItemStack(this.material);
        ItemMeta im = i.getItemMeta();
        im.setDisplayName(this.itemName);
        ArrayList<Object> lore = new ArrayList<Object>(this.itemLore != null ? this.itemLore : new ArrayList());
        lore.add(" ");
        if (this.reqClass != RPGClass.ANY) {
            lore.add("Class: " + this.getNormalName(this.reqClass));
        }
        if (this.reqLevel > 0) {
            lore.add("Required Level: " + this.reqLevel);
        }
        if (this.attack > 0) {
            lore.add("Attack: " + this.attack);
        }
        if (this.attackSpeed > 0) {
            lore.add("Attack Speed: " + this.attackSpeed);
        }
        if (this.defense > 0) {
            lore.add("Defense: " + this.defense);
        }
        if (this.health > 0) {
            lore.add("Health: " + this.health);
        }
        if (this.speed > 0) {
            lore.add("Speed: " + this.speed);
        }
        if (this.mana > 0) {
            lore.add("Mana: " + this.mana);
        }
        im.setLore(lore);
        NamespacedKey key = new NamespacedKey("rpgcore", "rpg_item_id");
        im.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)this.id);
        i.setItemMeta(im);
        return i;
    }

    private String getNormalName(RPGClass rpgClass) {
        return rpgClass.toString().substring(0, 1).toUpperCase() + rpgClass.toString().substring(1).toLowerCase();
    }

    private void generateId() {
        Object generated = "";
        int length = 64;
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < length; ++i) {
            generated = (String)generated + characters.charAt((int)Math.floor(Math.random() * (double)characters.length()));
        }
        if (ItemDictionary.items.containsKey(generated)) {
            this.generateId();
            return;
        }
        this.id = generated;
    }
}

