/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.pluginUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cz.vitekform.rPGCore.ItemDictionary;
import cz.vitekform.rPGCore.objects.RPGItem;
import cz.vitekform.rPGCore.pluginUtils.CatboxUploader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourcePackGenerator {
    private static final String NAMESPACE = "rpgcore";
    private static final int PACK_FORMAT = 46;
    private static final String RESOURCEPACK_CONFIG = "resourcepack.yml";
    private final JavaPlugin plugin;
    private final Logger logger;
    private final File dataFolder;
    private final File texturesFolder;
    private final File modelsFolder;
    private final File generatedFolder;
    private final Gson gson;
    private final CatboxUploader uploader;
    private static String resourcePackUrl;
    private static byte[] resourcePackHash;
    private static boolean resourcePackReady;

    public ResourcePackGenerator(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.dataFolder = plugin.getDataFolder();
        this.texturesFolder = new File(this.dataFolder, "items/textures");
        this.modelsFolder = new File(this.dataFolder, "items/models");
        this.generatedFolder = new File(this.dataFolder, "generated");
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.uploader = new CatboxUploader(this.logger);
    }

    public static String getResourcePackUrl() {
        return resourcePackUrl;
    }

    public static byte[] getResourcePackHash() {
        return resourcePackHash;
    }

    public static boolean isResourcePackReady() {
        return resourcePackReady;
    }

    public void generate() {
        this.logger.info("Starting resource pack generation...");
        this.ensureDirectories();
        File configFile = new File(this.dataFolder, RESOURCEPACK_CONFIG);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        Map<String, RPGItem> itemsWithCustomAssets = this.collectCustomAssetItems();
        if (itemsWithCustomAssets.isEmpty()) {
            this.logger.info("No items with custom textures/models found. Skipping resource pack generation.");
            resourcePackReady = false;
            return;
        }
        this.logger.info("Found " + itemsWithCustomAssets.size() + " items with custom assets.");
        File tempZip = new File(this.generatedFolder, "resourcepack.zip.tmp");
        File finalZip = new File(this.generatedFolder, "resourcepack.zip");
        try {
            boolean needsUpload;
            this.generateResourcePack(itemsWithCustomAssets, tempZip);
            String newHash = this.calculateFileHash(tempZip);
            boolean packChanged = true;
            if (finalZip.exists()) {
                String existingHash = this.calculateFileHash(finalZip);
                if (existingHash.equals(newHash)) {
                    this.logger.info("Resource pack unchanged. Keeping existing file.");
                    Files.delete(tempZip.toPath());
                    packChanged = false;
                } else {
                    this.logger.info("Resource pack changed. Replacing existing file.");
                    Files.move(tempZip.toPath(), finalZip.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else {
                Files.move(tempZip.toPath(), finalZip.toPath(), new CopyOption[0]);
            }
            this.logger.info("Resource pack generated at: " + finalZip.getAbsolutePath());
            String sha1Hash = this.calculateFileSha1(finalZip);
            String storedUrl = config.getString("url");
            String storedHash = config.getString("sha1");
            boolean bl = needsUpload = packChanged || storedUrl == null || storedHash == null;
            if (!needsUpload && storedUrl != null && storedHash != null) {
                if (storedHash.equals(sha1Hash) && this.uploader.verifyUrl(storedUrl)) {
                    this.logger.info("Stored resource pack URL is still valid. Using existing upload.");
                    resourcePackUrl = storedUrl;
                    resourcePackHash = ResourcePackGenerator.hexStringToByteArray(sha1Hash);
                    resourcePackReady = true;
                    return;
                }
                this.logger.info("Stored resource pack URL is invalid or hash mismatch. Re-uploading...");
                needsUpload = true;
            }
            if (needsUpload) {
                this.logger.info("Uploading resource pack to catbox.moe...");
                String uploadedUrl = this.uploader.upload(finalZip);
                if (uploadedUrl != null) {
                    config.set("url", (Object)uploadedUrl);
                    config.set("sha1", (Object)sha1Hash);
                    config.save(configFile);
                    resourcePackUrl = uploadedUrl;
                    resourcePackHash = ResourcePackGenerator.hexStringToByteArray(sha1Hash);
                    resourcePackReady = true;
                    this.logger.info("Resource pack uploaded successfully!");
                    this.logger.info("URL: " + uploadedUrl);
                    this.logger.info("SHA-1: " + sha1Hash);
                } else {
                    this.logger.severe("Failed to upload resource pack to catbox.moe!");
                    resourcePackReady = false;
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to generate resource pack: " + e.getMessage());
            e.printStackTrace();
            resourcePackReady = false;
        }
    }

    private String calculateFileSha1(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] hexStringToByteArray(String hex) {
        if (hex == null || ((String)hex).isEmpty()) {
            return new byte[0];
        }
        if (((String)hex).length() % 2 != 0) {
            hex = "0" + (String)hex;
        }
        int len = ((String)hex).length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(((String)hex).charAt(i), 16) << 4) + Character.digit(((String)hex).charAt(i + 1), 16));
        }
        return data;
    }

    private void ensureDirectories() {
        if (!this.texturesFolder.exists() && !this.texturesFolder.mkdirs()) {
            this.logger.warning("Failed to create textures directory: " + this.texturesFolder.getAbsolutePath());
        }
        if (!this.modelsFolder.exists() && !this.modelsFolder.mkdirs()) {
            this.logger.warning("Failed to create models directory: " + this.modelsFolder.getAbsolutePath());
        }
        if (!this.generatedFolder.exists() && !this.generatedFolder.mkdirs()) {
            this.logger.warning("Failed to create generated directory: " + this.generatedFolder.getAbsolutePath());
        }
    }

    private Map<String, RPGItem> collectCustomAssetItems() {
        LinkedHashMap<String, RPGItem> result = new LinkedHashMap<String, RPGItem>();
        for (Map.Entry<String, RPGItem> entry : ItemDictionary.items.entrySet()) {
            RPGItem item = entry.getValue();
            if (item.modelPath == null && item.modelType == null) continue;
            result.put(entry.getKey(), item);
        }
        return result;
    }

    private void generateResourcePack(Map<String, RPGItem> items, File outputFile) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));){
            this.addPackMcmeta(zos);
            for (Map.Entry<String, RPGItem> entry : items.entrySet()) {
                String itemKey = entry.getKey();
                RPGItem item = entry.getValue();
                this.processItem(zos, itemKey, item);
            }
        }
    }

    private void addPackMcmeta(ZipOutputStream zos) throws IOException {
        JsonObject packMcmeta = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)46);
        pack.addProperty("description", "RPGCore Custom Resource Pack");
        packMcmeta.add("pack", (JsonElement)pack);
        zos.putNextEntry(new ZipEntry("pack.mcmeta"));
        zos.write(this.gson.toJson((JsonElement)packMcmeta).getBytes());
        zos.closeEntry();
    }

    private void processItem(ZipOutputStream zos, String itemKey, RPGItem item) throws IOException {
        String modelKeyName = itemKey.toLowerCase().replace(" ", "_");
        boolean modelAdded = false;
        if (item.texturePath != null) {
            this.addTexture(zos, itemKey, item.texturePath);
        }
        if (item.modelPath != null) {
            if (this.addCustomModel(zos, itemKey, item.modelPath)) {
                modelAdded = true;
            }
        } else if (item.modelType != null) {
            if (item.texturePath == null) {
                this.logger.warning("Item " + itemKey + " has model.type but no texture.path. Skipping model generation.");
            } else {
                this.generateModel(zos, itemKey, item);
                modelAdded = true;
            }
        }
        if (modelAdded) {
            item.customModelKey = "rpgcore:" + modelKeyName;
            this.addItemDefinition(zos, itemKey, modelKeyName);
        }
    }

    private void addItemDefinition(ZipOutputStream zos, String itemKey, String modelKeyName) throws IOException {
        String zipPath = "assets/rpgcore/items/" + modelKeyName + ".json";
        JsonObject itemDefinition = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("type", "minecraft:model");
        model.addProperty("model", "rpgcore:item/" + modelKeyName);
        itemDefinition.add("model", (JsonElement)model);
        zos.putNextEntry(new ZipEntry(zipPath));
        zos.write(this.gson.toJson((JsonElement)itemDefinition).getBytes());
        zos.closeEntry();
        this.logger.info("Added item definition for " + itemKey + ": " + zipPath);
    }

    private void addTexture(ZipOutputStream zos, String itemKey, String texturePath) throws IOException {
        File textureFile = new File(this.texturesFolder, texturePath);
        if (!textureFile.exists()) {
            this.logger.warning("Texture file not found for item " + itemKey + ": " + texturePath);
            return;
        }
        String textureKeyName = itemKey.toLowerCase().replace(" ", "_");
        String zipPath = "assets/rpgcore/textures/item/" + textureKeyName + this.getFileExtension(texturePath);
        zos.putNextEntry(new ZipEntry(zipPath));
        Files.copy(textureFile.toPath(), zos);
        zos.closeEntry();
        this.logger.info("Added texture for " + itemKey + ": " + zipPath);
    }

    private boolean addCustomModel(ZipOutputStream zos, String itemKey, String modelPath) throws IOException {
        File modelFile = new File(this.modelsFolder, modelPath);
        if (!modelFile.exists()) {
            this.logger.warning("Model file not found for item " + itemKey + ": " + modelPath);
            return false;
        }
        String modelKeyName = itemKey.toLowerCase().replace(" ", "_");
        String zipPath = "assets/rpgcore/models/item/" + modelKeyName + ".json";
        zos.putNextEntry(new ZipEntry(zipPath));
        Files.copy(modelFile.toPath(), zos);
        zos.closeEntry();
        this.logger.info("Added custom model for " + itemKey + ": " + zipPath);
        return true;
    }

    private void generateModel(ZipOutputStream zos, String itemKey, RPGItem item) throws IOException {
        String modelKeyName = itemKey.toLowerCase().replace(" ", "_");
        String zipPath = "assets/rpgcore/models/item/" + modelKeyName + ".json";
        JsonObject model = this.createModelJson(item.modelType, modelKeyName);
        zos.putNextEntry(new ZipEntry(zipPath));
        zos.write(this.gson.toJson((JsonElement)model).getBytes());
        zos.closeEntry();
        this.logger.info("Generated model for " + itemKey + " (type: " + item.modelType + "): " + zipPath);
    }

    private JsonObject createModelJson(String modelType, String itemKeyName) {
        JsonObject model = new JsonObject();
        String parent = switch (modelType.toLowerCase()) {
            case "handheld" -> "minecraft:item/handheld";
            case "handheld_rod" -> "minecraft:item/handheld_rod";
            case "generated" -> "minecraft:item/generated";
            case "bow" -> "minecraft:item/bow";
            case "crossbow" -> "minecraft:item/crossbow";
            case "shield" -> "minecraft:builtin/entity";
            case "trident" -> "minecraft:item/trident_in_hand";
            default -> "minecraft:item/generated";
        };
        model.addProperty("parent", parent);
        JsonObject textures = new JsonObject();
        String textureRef = "rpgcore:item/" + itemKeyName;
        textures.addProperty("layer0", textureRef);
        model.add("textures", (JsonElement)textures);
        return model;
    }

    private String getFileExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot > 0) {
            return filename.substring(lastDot);
        }
        return ".png";
    }

    private String calculateFileHash(File file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    static {
        resourcePackReady = false;
    }
}

