/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.pluginUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.logging.Logger;

public class CatboxUploader {
    private static final String CATBOX_API_URL = "https://catbox.moe/user/api.php";
    private final Logger logger;

    public CatboxUploader(Logger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String upload(File file) {
        if (!file.exists()) {
            this.logger.warning("Cannot upload file: file does not exist: " + file.getAbsolutePath());
            return null;
        }
        String boundary = "----RPGCoreBoundary" + System.currentTimeMillis() + Math.random();
        try {
            BufferedReader reader;
            URL url = URI.create(CATBOX_API_URL).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("User-Agent", "RPGCore-Plugin");
            try (OutputStream outputStream = connection.getOutputStream();
                 PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);){
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"reqtype\"\r\n\r\n");
                writer.append("fileupload").append("\r\n");
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"fileToUpload\"; filename=\"").append(file.getName()).append("\"\r\n");
                writer.append("Content-Type: application/zip\r\n\r\n");
                writer.flush();
                Files.copy(file.toPath(), outputStream);
                outputStream.flush();
                writer.append("\r\n--").append(boundary).append("--\r\n");
                writer.flush();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    String response = reader.readLine();
                    if (response != null && response.startsWith("https://")) {
                        this.logger.info("Successfully uploaded resource pack to catbox.moe: " + response);
                        String string = response;
                        return string;
                    }
                    this.logger.warning("Unexpected response from catbox.moe: " + response);
                    String string = null;
                    return string;
                }
                finally {
                    reader.close();
                }
            }
            reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            try {
                String line;
                StringBuilder errorResponse = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    errorResponse.append(line);
                }
                this.logger.warning("Failed to upload to catbox.moe. Response code: " + responseCode + ", Error: " + String.valueOf(errorResponse));
                return null;
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            this.logger.severe("Error uploading to catbox.moe: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean verifyUrl(String downloadUrl) {
        if (downloadUrl == null || downloadUrl.isEmpty()) {
            return false;
        }
        try {
            boolean isValid;
            URL url = URI.create(downloadUrl).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setRequestProperty("User-Agent", "RPGCore-Plugin");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            boolean bl = isValid = responseCode == 200;
            if (!isValid) {
                this.logger.warning("Resource pack URL verification failed. Response code: " + responseCode);
            }
            return isValid;
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify resource pack URL: " + e.getMessage());
            return false;
        }
    }
}

