/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.listeners;

import cz.vitekform.rPGCore.RPGCore;
import cz.vitekform.rPGCore.objects.RPGEntity;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityDamageHandler
implements Listener {
    @EventHandler
    public void whenEntityDamaged(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                Player p = (Player)entity;
                double damage = (double)RPGCore.playerStorage.get((Object)p.getUniqueId()).attackDMG_Base + RPGCore.playerStorage.get((Object)p.getUniqueId()).attackDMG_Items;
                double critChance = RPGCore.playerStorage.get((Object)p.getUniqueId()).critChance_Base + RPGCore.playerStorage.get((Object)p.getUniqueId()).critChance_Items;
                if (Math.random() < critChance / 100.0) {
                    damage *= 2.0;
                    le.getWorld().spawnParticle(Particle.CRIT, le.getLocation(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                event.setDamage(damage);
            }
        }
    }

    @EventHandler
    public void whenEntityDies(EntityDeathEvent event) {
        Entity entity = event.getDamageSource().getCausingEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            RPGEntity rpgEntity = RPGCore.entityStorage.get(event.getEntity().getUniqueId());
            if (rpgEntity != null) {
                RPGCore.playerStorage.get(p.getUniqueId()).handleExpAdd(rpgEntity.experienceAfterDefeat);
                event.getDrops().addAll(rpgEntity.dropsAsItemStacks());
                RPGCore.entityStorage.remove(event.getEntity().getUniqueId());
            }
        }
    }
}

