/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.pluginUtils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cz.vitekform.rPGCore.objects.ReleaseChannel;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class PluginUpdater {
    public static final String pluginVersion = "0.0.1";
    public static final int build = 20;
    private static final ReleaseChannel releaseChannel = ReleaseChannel.DEV;

    public static int latestBuild(String channel) {
        String url = "https://blob.build/api/builds/RPGCore/" + channel + "/latest";
        try {
            String inputLine;
            URL urlObj = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlObj.openStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            in.close();
            JsonObject jsonObject = new JsonParser().parse(content.toString()).getAsJsonObject();
            JsonObject dataObject = jsonObject.getAsJsonObject("data");
            return dataObject.get("build_id").getAsInt();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static boolean isLatest() {
        int latest = PluginUpdater.latestBuild(PluginUpdater.buildChannelString());
        return latest == 20;
    }

    public static Component update() {
        if (PluginUpdater.isLatest()) {
            return Component.text((String)"You are already running the latest build of RPGCore.", (TextColor)NamedTextColor.GREEN);
        }
        String url = "https://blob.build/api/builds/RPGCore/" + PluginUpdater.buildChannelString() + "/latest";
        String downloadUrl = "";
        try {
            String inputLine;
            URL urlObj = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlObj.openStream()));
            Object content = "";
            while ((inputLine = in.readLine()) != null) {
                content = (String)content + inputLine + "\n";
            }
            in.close();
            JsonObject jsonObject = new JsonParser().parse((String)content).getAsJsonObject();
            System.out.println(jsonObject);
            JsonObject dataObject = jsonObject.getAsJsonObject("data");
            downloadUrl = dataObject.get("file_download_url").getAsString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Component.text((String)"An error occurred while trying to update the plugin. Error occurred while fetching the latest version build URL!", (TextColor)NamedTextColor.RED);
        }
        try (BufferedInputStream in = new BufferedInputStream(new URL(downloadUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(System.getProperty("user.dir") + File.separator + "plugins" + File.separator + "RPGCoreNEW.jar");){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return Component.text((String)"An error occurred while trying to update the plugin. Error occurred while downloading the new version!", (TextColor)NamedTextColor.RED);
        }
        try {
            Files.deleteIfExists(Paths.get(System.getProperty("user.dir") + File.separator + "plugins" + File.separator + "RPGCore.jar", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Component.text((String)"An error occurred while trying to update the plugin. Error occurred while deleting the old version!", (TextColor)NamedTextColor.RED);
        }
        try {
            File f = new File(System.getProperty("user.dir") + File.separator + "plugins" + File.separator + "RPGCoreNEW.jar");
            f.renameTo(new File(System.getProperty("user.dir") + File.separator + "plugins" + File.separator + "RPGCore.jar"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Component.text((String)"An error occurred while trying to update the plugin. Error occurred while renaming the new version!", (TextColor)NamedTextColor.RED);
        }
        return Component.text((String)("Plugin updated successfully to build " + PluginUpdater.latestBuild(PluginUpdater.buildChannelString()) + "!"), (TextColor)NamedTextColor.GREEN);
    }

    public static String buildChannelString() {
        switch (releaseChannel) {
            case DEV: {
                return "Dev";
            }
            case ALPHA: {
                return "Alpha";
            }
            case BETA: {
                return "Beta";
            }
            case RELEASE: {
                return "Release";
            }
        }
        return "Unknown";
    }
}

