/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cz.vitekform.rPGCore.EntityDictionary;
import cz.vitekform.rPGCore.ItemDictionary;
import cz.vitekform.rPGCore.commands.args.classes.RPGCoreSubcommandArgument;
import cz.vitekform.rPGCore.commands.args.enums.RPGCoreSubcommand;
import cz.vitekform.rPGCore.listeners.EntityDamageHandler;
import cz.vitekform.rPGCore.listeners.InventoryHandler;
import cz.vitekform.rPGCore.listeners.LoginHandler;
import cz.vitekform.rPGCore.listeners.PlayerDamageHandler;
import cz.vitekform.rPGCore.listeners.PlayerEatFoodHandler;
import cz.vitekform.rPGCore.objects.RPGAttribute;
import cz.vitekform.rPGCore.objects.RPGClass;
import cz.vitekform.rPGCore.objects.RPGEntity;
import cz.vitekform.rPGCore.objects.RPGItem;
import cz.vitekform.rPGCore.objects.RPGPlayer;
import cz.vitekform.rPGCore.pluginUtils.PluginUpdater;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class RPGCore
extends JavaPlugin {
    public static final Map<UUID, RPGPlayer> playerStorage = new HashMap<UUID, RPGPlayer>();
    public static final Map<UUID, RPGEntity> entityStorage = new HashMap<UUID, RPGEntity>();

    public static List<Component> fancyText(List<Component> original) {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<TextColor> colors = new ArrayList<TextColor>();
        ArrayList<Map<TextDecoration, TextDecoration.State>> decorations = new ArrayList<Map<TextDecoration, TextDecoration.State>>();
        ArrayList<String> nLines = new ArrayList<String>();
        for (Component c : original) {
            String plainText = PlainTextComponentSerializer.plainText().serialize(c);
            lines.add(plainText);
            colors.add(c.color());
            if (!c.decorations().isEmpty()) {
                decorations.add(c.decorations());
                continue;
            }
            decorations.add(Map.of(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        }
        for (String s : lines) {
            char[] chars = s.toCharArray();
            ArrayList<Character> nChars = new ArrayList<Character>();
            for (int n : chars) {
                if (n == 97 || n == 65) {
                    n = 7424;
                } else if (n == 98 || n == 66) {
                    n = 665;
                } else if (n == 99 || n == 67) {
                    n = 7428;
                } else if (n == 100 || n == 68) {
                    n = 7429;
                } else if (n == 101 || n == 69) {
                    n = 7431;
                } else if (n == 102 || n == 70) {
                    n = 42800;
                } else if (n == 103 || n == 71) {
                    n = 610;
                } else if (n == 104 || n == 72) {
                    n = 668;
                } else if (n == 105 || n == 73) {
                    n = 618;
                } else if (n == 106 || n == 74) {
                    n = 7434;
                } else if (n == 107 || n == 75) {
                    n = 7435;
                } else if (n == 108 || n == 76) {
                    n = 671;
                } else if (n == 109 || n == 77) {
                    n = 7437;
                } else if (n == 110 || n == 78) {
                    n = 628;
                } else if (n == 111 || n == 79) {
                    n = 7439;
                } else if (n == 112 || n == 80) {
                    n = 7448;
                } else if (n == 113 || n == 81) {
                    n = 491;
                } else if (n == 114 || n == 82) {
                    n = 640;
                } else if (n == 115 || n == 83) {
                    n = 115;
                } else if (n == 116 || n == 84) {
                    n = 7451;
                } else if (n == 117 || n == 85) {
                    n = 7452;
                } else if (n == 118 || n == 86) {
                    n = 7456;
                } else if (n == 119 || n == 87) {
                    n = 7457;
                } else if (n == 120 || n == 88) {
                    n = 120;
                } else if (n == 121 || n == 89) {
                    n = 655;
                } else if (n == 122 || n == 90) {
                    n = 7458;
                }
                nChars.add(Character.valueOf((char)n));
            }
            Object nString = "";
            for (Character c : nChars) {
                nString = (String)nString + c;
            }
            if (((String)nString).isBlank()) continue;
            nLines.add((String)nString);
            colors.add((TextColor)colors.get(lines.indexOf(s)));
        }
        ArrayList<Component> nComponents = new ArrayList<Component>();
        for (int i = 0; i < nLines.size(); ++i) {
            nComponents.add(Component.text((String)((String)nLines.get(i)), (TextColor)((TextColor)colors.get(i))).decorations((Map)decorations.get(i)));
        }
        return nComponents;
    }

    public void onEnable() {
        this.getLogger().info(String.valueOf(ChatColor.YELLOW) + "Loading ganamaga's RPGCore...");
        if (PluginUpdater.isLatest()) {
            this.getLogger().info(String.valueOf(ChatColor.GREEN) + "You are running the latest version of RPGCore.");
        } else {
            this.getLogger().info(String.valueOf(ChatColor.RED) + "You are not running the latest version of RPGCore. Please update to build " + PluginUpdater.latestBuild(PluginUpdater.buildChannelString()) + " from " + PluginUpdater.buildChannelString() + " Build Channel. Using /rpg update");
        }
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register(((LiteralArgumentBuilder)Commands.literal((String)"rpgcore").then(Commands.argument((String)"subcommand", (ArgumentType)new RPGCoreSubcommandArgument()).executes(ctx -> {
                this.handleMainCommand((CommandContext<CommandSourceStack>)ctx, this);
                return 1;
            }))).build(), "The main command for RPGCore.", List.of("rpg", "rpgc", "core"));
        });
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new LoginHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerDamageHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EntityDamageHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerEatFoodHandler(), (Plugin)this);
        FileConfiguration entityData = RPGCore.safeGetConfig("entityData.yml");
        if (entityData.contains("entity")) {
            for (String key : entityData.getConfigurationSection("entity").getKeys(false)) {
                String path = "entity." + key + ".";
                RPGEntity entity = new RPGEntity();
                entity.visibleName = entityData.getString(path + "visibleName", "");
                entity.level = entityData.getInt(path + "level", 1);
                entity.maxHealth = entityData.getInt(path + "maxHealth", 20);
                entity.health = entityData.getInt(path + "health", 20);
                entity.attack = entityData.getDouble(path + "attack", 1.0);
                entity.defense = entityData.getInt(path + "defense", 0);
                entity.speed = entityData.getDouble(path + "speed", 0.1);
                entity.experienceAfterDefeat = entityData.getInt(path + "experienceAfterDefeat", 0);
                List drops = entityData.getStringList(path + "drops");
                for (String drop : drops) {
                    if (!ItemDictionary.items.containsKey(drop)) continue;
                    entity.drops.add(ItemDictionary.items.get(drop));
                }
                entity.isBoss = entityData.getBoolean(path + "isBoss", false);
                entity.isFriendly = entityData.getBoolean(path + "isFriendly", false);
                entity.hasVisibleName = entityData.getBoolean(path + "hasVisibleName", false);
                UUID uuid = UUID.fromString(key);
                entityStorage.put(uuid, entity);
            }
        }
        super.onEnable();
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "RPGCore Loaded!");
    }

    public void onDisable() {
        this.getLogger().info(String.valueOf(ChatColor.YELLOW) + "Disabling ganamaga's RPGCore...");
        FileConfiguration entityData = RPGCore.safeGetConfig("entityData.yml");
        for (Map.Entry<UUID, RPGEntity> entry : entityStorage.entrySet()) {
            RPGEntity entity = entry.getValue();
            Entity nEntity = Bukkit.getEntity((UUID)entry.getKey());
            Location loc = null;
            if (nEntity != null && nEntity instanceof LivingEntity) {
                loc = nEntity.getLocation();
            } else {
                this.getLogger().warning("Entity with UUID " + String.valueOf(entry.getKey()) + " not found in the world (This is most likely caused by natural despawn). Skipping saving its data.");
            }
            String path = "entity." + entry.getKey().toString() + ".";
            entityData.set(path + "visibleName", (Object)entity.visibleName);
            entityData.set(path + "level", (Object)entity.level);
            entityData.set(path + "maxHealth", (Object)entity.maxHealth);
            entityData.set(path + "health", (Object)entity.health);
            entityData.set(path + "attack", (Object)entity.attack);
            entityData.set(path + "defense", (Object)entity.defense);
            entityData.set(path + "speed", (Object)entity.speed);
            entityData.set(path + "experienceAfterDefeat", (Object)entity.experienceAfterDefeat);
            ArrayList<String> drops = new ArrayList<String>();
            for (RPGItem drop : entity.drops) {
                drops.add(drop.itemName.toString());
            }
            entityData.set(path + "drops", drops);
            entityData.set(path + "isBoss", (Object)entity.isBoss);
            entityData.set(path + "isFriendly", (Object)entity.isFriendly);
            entityData.set(path + "hasVisibleName", (Object)entity.hasVisibleName);
            if (entity.entityType == null) continue;
            entityData.set(path + "entityType", (Object)entity.entityType.name());
        }
        try {
            entityData.save(new File(this.getDataFolder(), "entityData.yml"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.onDisable();
        this.getLogger().info(String.valueOf(ChatColor.RED) + "RPGCore Disabled!");
    }

    private void handleMainCommand(CommandContext<CommandSourceStack> ctx, RPGCore plugin) {
        if (((CommandSourceStack)ctx.getSource()).getSender().hasPermission("rpgcore.admin")) {
            if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.UPDATE)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(PluginUpdater.update());
                if (!PluginUpdater.isLatest()) {
                    Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.VERSION)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Currently running version 0.0.1 Build 20 from " + PluginUpdater.buildChannelString() + " Build Channel"), (TextColor)NamedTextColor.GREEN));
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.CLASS)) {
                Player p;
                CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
                if (commandSender instanceof Player && playerStorage.containsKey((p = (Player)commandSender).getUniqueId())) {
                    RPGPlayer pl = playerStorage.get(p.getUniqueId());
                    if (pl.rpgClass == RPGClass.NONE) {
                        Inventory gui = Bukkit.createInventory((InventoryHolder)p, (int)27, (String)"Select your class");
                        ItemStack nothing = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                        ItemMeta nothingMeta = nothing.getItemMeta();
                        nothingMeta.displayName((Component)Component.text((String)" "));
                        nothing.setItemMeta(nothingMeta);
                        for (int i = 0; i < 27; ++i) {
                            gui.setItem(i, nothing);
                        }
                        gui.setItem(10, ItemDictionary.warriorClassItem().build());
                        gui.setItem(13, ItemDictionary.archerClassItem().build());
                        gui.setItem(16, ItemDictionary.mageClassItem().build());
                        p.openInventory(gui);
                    } else {
                        p.sendMessage((Component)Component.text((String)"You already have a class!", (TextColor)NamedTextColor.RED));
                    }
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.ATTRIBUTES)) {
                Player p;
                CommandSender pl = ((CommandSourceStack)ctx.getSource()).getSender();
                if (pl instanceof Player && playerStorage.containsKey((p = (Player)pl).getUniqueId())) {
                    Inventory gui = Bukkit.createInventory((InventoryHolder)p, (int)27, (String)"Your attributes");
                    ItemStack nothing = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                    ItemMeta nothingMeta = nothing.getItemMeta();
                    nothingMeta.displayName((Component)Component.text((String)" "));
                    nothing.setItemMeta(nothingMeta);
                    for (int i = 0; i < 27; ++i) {
                        gui.setItem(i, nothing);
                    }
                    gui.setItem(9, ItemDictionary.strengthAttributeItem().build());
                    gui.setItem(11, ItemDictionary.dexterityAttributeItem().build());
                    gui.setItem(13, ItemDictionary.intelligenceAttributeItem().build());
                    gui.setItem(15, ItemDictionary.enduranceAttributeItem().build());
                    gui.setItem(17, ItemDictionary.vitalityAttributeItem().build());
                    gui.setItem(26, ItemDictionary.attributePointsItem(playerStorage.get(p.getUniqueId())).build());
                    p.openInventory(gui);
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.HELP)) {
                HashMap<String, TextComponent> help = new HashMap<String, TextComponent>();
                help.put("update", Component.text((String)"Update the plugin.", (TextColor)NamedTextColor.GREEN));
                help.put("version", Component.text((String)"Get the current version of the plugin.", (TextColor)NamedTextColor.GREEN));
                help.put("help", Component.text((String)"Get help.", (TextColor)NamedTextColor.GREEN));
                for (Map.Entry entry : help.entrySet()) {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(Component.text((String)("/rpgcore " + (String)entry.getKey() + " - "), (TextColor)NamedTextColor.GRAY).append((Component)entry.getValue()));
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.KIT_ADVENTURER)) {
                CommandSender gui = ((CommandSourceStack)ctx.getSource()).getSender();
                if (gui instanceof Player) {
                    Player p = (Player)gui;
                    RPGPlayer pl = playerStorage.get(p.getUniqueId());
                    if (pl != null) {
                        pl.giveItem(ItemDictionary.adventurerSword());
                        pl.giveItem(ItemDictionary.adventurerHelmet());
                        pl.giveItem(ItemDictionary.adventurerChestplate());
                        pl.giveItem(ItemDictionary.adventurerLeggings());
                        pl.giveItem(ItemDictionary.adventurerBoots());
                        pl.giveItem(ItemDictionary.staleBread(), 5);
                        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"You have been given an Adventurer's kit!", (TextColor)NamedTextColor.GREEN));
                    } else {
                        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"You are not a registered RPG player.", (TextColor)NamedTextColor.RED));
                    }
                } else {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"This command can only be used by players.", (TextColor)NamedTextColor.RED));
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.SUMMON)) {
                Object pl = ((CommandSourceStack)ctx.getSource()).getSender();
                if (pl instanceof Player) {
                    Player p = (Player)pl;
                    if ((pl = playerStorage.get(p.getUniqueId())) != null) {
                        Location loc = p.getLocation();
                        RPGEntity entity = EntityDictionary.BANDIT_TUTORIAL_MELEE();
                        UUID uuid = entity.spawnIn(loc).getUniqueId();
                        entityStorage.put(uuid, entity);
                        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"Test entity summoned!", (TextColor)NamedTextColor.GREEN));
                    } else {
                        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"You are not a registered RPG player.", (TextColor)NamedTextColor.RED));
                    }
                } else {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"This command can only be used by players.", (TextColor)NamedTextColor.RED));
                }
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.TEST)) {
                Player p = (Player)((CommandSourceStack)ctx.getSource()).getSender();
                RPGPlayer pl = playerStorage.get(p.getUniqueId());
                pl.updateItemStats();
                p.sendMessage((Component)Component.text((String)"Your stats have been updated.", (TextColor)NamedTextColor.GREEN));
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"Unknown subcommand.", (TextColor)NamedTextColor.RED));
            }
        }
    }

    public static FileConfiguration safeGetConfig(String name) {
        String dataFolder = System.getProperty("user.dir") + "/plugins/RPGCore";
        if (!new File(dataFolder).exists()) {
            new File(dataFolder).mkdir();
        }
        if (!new File(dataFolder, name).exists()) {
            try {
                new File(dataFolder, name).createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return YamlConfiguration.loadConfiguration((File)new File(dataFolder, name));
    }

    public static void syncDataWithReality(Player p) {
        RPGPlayer pl = playerStorage.get(p.getUniqueId());
        pl.maxHealth_Base = pl.totalAttributes().get((Object)RPGAttribute.ENDURANCE) * 10;
        if (pl.maxHealth_Base == 0.0) {
            pl.maxHealth_Base = 1.0;
        }
        if (pl.health > pl.maxHealth_Base + (double)pl.health_Items) {
            pl.health = pl.maxHealth_Base + (double)pl.health_Items;
        }
        pl.maxMana_Base = pl.totalAttributes().get((Object)RPGAttribute.INTELLIGENCE) * 10;
        RPGCore.playerStatsCycleStart(pl);
    }

    private static void playerStatsCycleStart(final RPGPlayer p) {
        final Player pl = Bukkit.getPlayer((UUID)p.uuid);
        pl.setMaxHealth(40.0);
        new BukkitRunnable(){

            public void run() {
                int maxMana;
                int mana;
                if (!pl.isOnline() || !playerStorage.containsKey(pl.getUniqueId())) {
                    this.cancel();
                    return;
                }
                double health = p.health;
                double maxHealth = p.maxHealth_Base + (double)p.health_Items;
                if (health > maxHealth) {
                    health = maxHealth;
                }
                if ((mana = p.mana) > (maxMana = p.maxMana_Base + p.mana_Items)) {
                    mana = maxMana;
                }
                int defense = p.defense_Base + p.defense_Items;
                double healthFactor = health / maxHealth;
                if (healthFactor > 1.0) {
                    healthFactor = 1.0;
                }
                if (healthFactor <= 0.0) {
                    pl.setHealth(0.0);
                    return;
                }
                pl.setHealth(healthFactor * 40.0);
                pl.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.RED) + "\u2764 " + health + "/" + maxHealth + "  " + String.valueOf(ChatColor.BLUE) + "\u2726 " + mana + "/" + maxMana + "  " + String.valueOf(ChatColor.GREEN) + "\ud83d\udee1 " + defense), (TextColor)NamedTextColor.WHITE));
            }
        }.runTaskTimer((Plugin)RPGCore.getPlugin(RPGCore.class), 10L, 5L);
        new BukkitRunnable(){

            public void run() {
                if (pl.isOnline()) {
                    double regenFactor = p.totalAttributes().get((Object)RPGAttribute.VITALITY).intValue();
                    if (regenFactor < 1.0) {
                        regenFactor = 1.0;
                    }
                    if (pl.getFoodLevel() > 15 && p.health < p.maxHealth_Base + (double)p.health_Items) {
                        p.health += regenFactor;
                        if (p.health > p.maxHealth_Base + (double)p.health_Items) {
                            p.health = p.maxHealth_Base + (double)p.health_Items;
                        }
                    }
                    if (pl.getFoodLevel() > 15 && p.mana < p.maxMana_Base + p.mana_Items) {
                        p.mana += (int)regenFactor;
                        if (p.mana > p.maxMana_Base + p.mana_Items) {
                            p.mana = p.maxMana_Base + p.mana_Items;
                        }
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)RPGCore.getPlugin(RPGCore.class), 10L, 20L);
    }
}

