/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.pluginUtils;

import cz.vitekform.rPGCore.objects.ReleaseChannel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class PluginUpdater {
    public static final String pluginVersion = "0.0.1";
    public static final int build = 1;
    private static final ReleaseChannel releaseChannel = ReleaseChannel.DEV;
    private static final String dataURL = "https://raw.githubusercontent.com/vitekform/RPGCore/master/src/main/java/cz/vitekform/rPGCore/pluginUtils/PluginUpdater.java";

    public static boolean isLatest() {
        try {
            String line;
            URL url = new URL(dataURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            Object totalContent = "";
            while ((line = reader.readLine()) != null) {
                totalContent = (String)totalContent + line;
            }
            reader.close();
            String[] lines = ((String)totalContent).split("\n");
            String pluginVersionLine = "";
            for (String l : lines) {
                if (!l.contains("public static final String pluginVersion")) continue;
                pluginVersionLine = l;
                break;
            }
            String buildLine = "";
            for (String l : lines) {
                if (!l.contains("public static final int build")) continue;
                buildLine = l;
                break;
            }
            int plVer = Integer.parseInt(pluginVersionLine.split("\"")[1].replace(".", ""));
            int bld = Integer.parseInt(buildLine.split(" ")[5].replace(";", ""));
            if (plVer > Integer.parseInt(pluginVersion.replace(".", ""))) {
                return false;
            }
            if (plVer == Integer.parseInt(pluginVersion.replace(".", ""))) {
                return bld >= 1;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String latestVersion() {
        try {
            String line;
            URL url = new URL(dataURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            Object totalContent = "";
            while ((line = reader.readLine()) != null) {
                totalContent = (String)totalContent + line;
            }
            reader.close();
            String[] lines = ((String)totalContent).split("\n");
            String pluginVersionLine = "";
            for (String l : lines) {
                if (!l.contains("private static final String pluginVersion")) continue;
                pluginVersionLine = l;
                break;
            }
            int plVer = Integer.parseInt(pluginVersionLine.split("\"")[1].replace(".", ""));
            return pluginVersionLine.split("\"")[1];
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void update() {
        String latestVersion = PluginUpdater.latestVersion();
        if (PluginUpdater.isLatest()) {
            return;
        }
        String plReleaseURL = "https://github.com/vitekform/RPGCore/releases/download/" + latestVersion + "/plugin.jar";
        String downloadCommand = "wget " + plReleaseURL + " -O plugins/RPGCoreLatest.jar";
        try {
            Process p = Runtime.getRuntime().exec(downloadCommand);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String deleteCommand = "rm plugins/RPGCore.jar";
        try {
            Process p = Runtime.getRuntime().exec(deleteCommand);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String renameCommand = "mv plugins/RPGCoreLatest.jar plugins/RPGCore.jar";
        try {
            Process p = Runtime.getRuntime().exec(renameCommand);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String buildChannelString() {
        switch (releaseChannel) {
            case DEV: {
                return "Development";
            }
            case ALPHA: {
                return "Alpha";
            }
            case BETA: {
                return "Beta";
            }
            case RELEASE: {
                return "Release";
            }
        }
        return "Unknown";
    }
}

