/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cz.vitekform.rPGCore.ItemDictionary;
import cz.vitekform.rPGCore.commands.args.classes.RPGCoreSubcommandArgument;
import cz.vitekform.rPGCore.commands.args.enums.RPGCoreSubcommand;
import cz.vitekform.rPGCore.listeners.InventoryHandler;
import cz.vitekform.rPGCore.listeners.LoginHandler;
import cz.vitekform.rPGCore.listeners.PlayerDamageHandler;
import cz.vitekform.rPGCore.objects.RPGClass;
import cz.vitekform.rPGCore.objects.RPGPlayer;
import cz.vitekform.rPGCore.pluginUtils.PluginUpdater;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class RPGCore
extends JavaPlugin {
    public static final Map<UUID, RPGPlayer> playerStorage = new HashMap<UUID, RPGPlayer>();

    public void onEnable() {
        this.getLogger().info(String.valueOf(ChatColor.YELLOW) + "Loading ganamaga's RPGCore...");
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register(((LiteralArgumentBuilder)Commands.literal((String)"rpgcore").then(Commands.argument((String)"subcommand", (ArgumentType)new RPGCoreSubcommandArgument()).executes(ctx -> {
                this.handleMainCommand((CommandContext<CommandSourceStack>)ctx);
                return 1;
            }))).build(), "The main command for RPGCore.", List.of("rpg", "rpgc", "core"));
            commands.register(((LiteralArgumentBuilder)Commands.literal((String)"class").executes(ctx -> {
                Player p;
                CommandSender patt0$temp = ((CommandSourceStack)ctx.getSource()).getSender();
                if (patt0$temp instanceof Player && playerStorage.containsKey((p = (Player)patt0$temp).getUniqueId())) {
                    RPGPlayer pl = playerStorage.get(p.getUniqueId());
                    if (pl.rpgClass == RPGClass.NONE) {
                        Inventory gui = Bukkit.createInventory((InventoryHolder)p, (int)27, (String)"Select your class");
                        ItemStack nothing = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
                        ItemMeta nothingMeta = nothing.getItemMeta();
                        nothingMeta.displayName((Component)Component.text((String)" "));
                        nothing.setItemMeta(nothingMeta);
                        for (int i = 0; i < 27; ++i) {
                            gui.setItem(i, nothing);
                        }
                        gui.setItem(10, ItemDictionary.warriorClassItem().build());
                        gui.setItem(13, ItemDictionary.archerClassItem().build());
                        gui.setItem(16, ItemDictionary.mageClassItem().build());
                        p.openInventory(gui);
                    } else {
                        p.sendMessage((Component)Component.text((String)"You already have a class!", (TextColor)NamedTextColor.RED));
                    }
                }
                return 1;
            })).build(), "Opens Class Selection Menu", List.of("classes"));
        });
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new LoginHandler(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerDamageHandler(), (Plugin)this);
        super.onEnable();
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "RPGCore Loaded!");
    }

    public void onDisable() {
        super.onDisable();
    }

    private void handleMainCommand(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getSender().hasPermission("rpgcore.admin")) {
            if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.UPDATE)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"We are sorry but this feature is not available yet.", (TextColor)NamedTextColor.RED));
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.VERSION)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)("Currently running version 0.0.1 Build 1 from " + PluginUpdater.buildChannelString() + " Build Channel"), (TextColor)NamedTextColor.GREEN));
            } else if (((RPGCoreSubcommand)((Object)ctx.getArgument("subcommand", RPGCoreSubcommand.class))).equals((Object)RPGCoreSubcommand.HELP)) {
                HashMap<String, TextComponent> help = new HashMap<String, TextComponent>();
                help.put("update", Component.text((String)"Update the plugin.", (TextColor)NamedTextColor.GREEN));
                help.put("version", Component.text((String)"Get the current version of the plugin.", (TextColor)NamedTextColor.GREEN));
                help.put("help", Component.text((String)"Get help.", (TextColor)NamedTextColor.GREEN));
                for (Map.Entry entry : help.entrySet()) {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(Component.text((String)("/rpgcore " + (String)entry.getKey() + " - "), (TextColor)NamedTextColor.GRAY).append((Component)entry.getValue()));
                }
            } else {
                ((CommandSourceStack)ctx.getSource()).getSender().sendMessage((Component)Component.text((String)"Unknown subcommand.", (TextColor)NamedTextColor.RED));
            }
        }
    }

    public static FileConfiguration safeGetConfig(String name) {
        String dataFolder = System.getProperty("user.dir") + "/plugins/RPGCore";
        if (!new File(dataFolder).exists()) {
            new File(dataFolder).mkdir();
        }
        if (!new File(dataFolder, name).exists()) {
            try {
                new File(dataFolder, name).createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return YamlConfiguration.loadConfiguration((File)new File(dataFolder, name));
    }

    public static void syncDataWithReality(Player p) {
        RPGPlayer pl = playerStorage.get(p.getUniqueId());
        pl.maxHealth = pl.endurance * 10;
        if (pl.maxHealth == 0.0) {
            pl.maxHealth = 1.0;
        }
        if (pl.health > pl.maxHealth) {
            pl.health = pl.maxHealth;
        }
        pl.maxMana = pl.intelligence * 10;
        RPGCore.playerStatsCycleStart(pl);
    }

    private static void playerStatsCycleStart(final RPGPlayer p) {
        final Player pl = Bukkit.getPlayer((UUID)p.uuid);
        pl.setMaxHealth(40.0);
        new BukkitRunnable(){

            public void run() {
                double maxHealth = p.maxHealth;
                double health = p.health;
                int maxMana = p.maxMana;
                int mana = p.mana;
                int level = p.level;
                int exp = p.exp;
                int maxExp = p.maxExp;
                int defense = p.defense;
                double healthFactor = health / maxHealth;
                pl.setHealth(healthFactor * 40.0);
                pl.sendActionBar((Component)Component.text((String)(String.valueOf(ChatColor.RED) + "\u2764 " + health + "/" + maxHealth + "  " + String.valueOf(ChatColor.BLUE) + "\u2726 " + mana + "/" + maxMana + "  " + String.valueOf(ChatColor.GREEN) + "\ud83d\udee1 " + defense), (TextColor)NamedTextColor.WHITE));
            }
        }.runTaskTimer((Plugin)RPGCore.getPlugin(RPGCore.class), 10L, 5L);
    }
}

