/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.objects;

import cz.vitekform.rPGCore.objects.RPGClass;
import java.util.UUID;
import org.bukkit.Bukkit;

public class RPGPlayer {
    public UUID uuid;
    public String ingameNick;
    public String rpgName;
    public int level;
    public int defense;
    public int exp;
    public int maxExp;
    public int skillPoints;
    public int strength;
    public int dexterity;
    public int intelligence;
    public int vitality;
    public int endurance;
    public int totalSkillPoints;
    public int attributePoints;
    public int totalAttributePoints;
    public double maxHealth;
    public double health;
    public int maxMana;
    public int mana;
    public RPGClass rpgClass;

    public RPGPlayer(UUID uuid, String ingameNick, String rpgName, int level, int exp, int maxExp, int skillPoints, int strength, int dexterity, int intelligence, int vitality, int endurance, int totalSkillPoints, int attributePoints, double maxHealth, double health, int maxMana, int mana, String rpgClass) {
        this.uuid = uuid;
        this.ingameNick = ingameNick;
        this.rpgName = rpgName;
        this.level = level;
        this.exp = exp;
        this.maxExp = maxExp;
        this.skillPoints = skillPoints;
        this.strength = strength;
        this.dexterity = dexterity;
        this.intelligence = intelligence;
        this.vitality = vitality;
        this.endurance = endurance;
        this.totalSkillPoints = totalSkillPoints;
        this.attributePoints = attributePoints;
        this.maxHealth = maxHealth;
        this.health = health;
        this.maxMana = maxMana;
        this.mana = mana;
        this.rpgClass = RPGClass.valueOf(rpgClass);
    }

    public RPGPlayer(UUID uuid) {
        this.uuid = uuid;
        this.ingameNick = Bukkit.getPlayer((UUID)uuid).getName();
        this.rpgName = null;
        this.level = 1;
        this.exp = 0;
        this.maxExp = 100;
        this.skillPoints = 0;
        this.strength = 0;
        this.dexterity = 0;
        this.intelligence = 0;
        this.vitality = 0;
        this.endurance = 0;
        this.totalSkillPoints = 0;
        this.attributePoints = 25;
        this.totalAttributePoints = 25;
        this.maxHealth = 1.0;
        this.health = 1.0;
        this.defense = 0;
        this.maxMana = 0;
        this.mana = 0;
        this.rpgClass = RPGClass.NONE;
    }

    public void levelUp() {
        ++this.level;
        this.maxExp = (int)((double)this.maxExp * 1.1);
        this.exp = 0;
        ++this.skillPoints;
        this.attributePoints += 5;
        ++this.totalSkillPoints;
        this.totalAttributePoints += 5;
    }

    public void addExp(int exp) {
        this.exp += exp;
        if (this.exp >= this.maxExp) {
            this.levelUp();
        }
    }

    public void addSkillPoints(int skillPoints) {
        this.skillPoints += skillPoints;
    }

    public void addAttributePoints(int attributePoints) {
        this.attributePoints += attributePoints;
    }

    public void addStrength(int strength) {
        this.strength += strength;
    }

    public void addDexterity(int dexterity) {
        this.dexterity += dexterity;
    }

    public void addIntelligence(int intelligence) {
        this.intelligence += intelligence;
    }

    public void addVitality(int vitality) {
        this.vitality += vitality;
    }

    public void addEndurance(int endurance) {
        this.endurance += endurance;
    }

    public void addMaxHealth(int health) {
        this.maxHealth += (double)health;
    }

    public void addMana(int mana) {
        this.mana += mana;
    }

    public void addMaxMana(int mana) {
        this.maxMana += mana;
    }

    public void setRpgClass(RPGClass rpgClass) {
        this.rpgClass = rpgClass;
    }

    public void setRpgName(String rpgName) {
        this.rpgName = rpgName;
    }

    public void setIngameNick(String ingameNick) {
        this.ingameNick = ingameNick;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public void setMaxExp(int maxExp) {
        this.maxExp = maxExp;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public void setDexterity(int dexterity) {
        this.dexterity = dexterity;
    }

    public void setIntelligence(int intelligence) {
        this.intelligence = intelligence;
    }

    public void setVitality(int vitality) {
        this.vitality = vitality;
    }

    public void setEndurance(int endurance) {
        this.endurance = endurance;
    }

    public void setTotalSkillPoints(int totalSkillPoints) {
        this.totalSkillPoints = totalSkillPoints;
    }

    public void setAttributePoints(int attributePoints) {
        this.attributePoints = attributePoints;
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public void setMaxMana(int maxMana) {
        this.maxMana = maxMana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    public void setDefense(int defense) {
        this.defense = defense;
    }
}

