/*
 * Decompiled with CFR 0.152.
 */
package cz.vitekform.rPGCore.objects;

import cz.vitekform.rPGCore.objects.RPGAttribute;
import cz.vitekform.rPGCore.objects.RPGClass;
import cz.vitekform.rPGCore.objects.RPGItem;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class RPGPlayer {
    public UUID uuid;
    public String ingameNick;
    public String rpgName;
    public int level;
    public int defense_Base;
    public int exp;
    public int maxExp;
    public int skillPoints;
    public Map<RPGAttribute, Integer> baseAttributes;
    public Map<RPGAttribute, Integer> itemAttributes;
    public double critChance_Base;
    public double critChance_Items;
    public int totalSkillPoints;
    public int attributePoints;
    public int totalAttributePoints;
    public double maxHealth_Base;
    public double health;
    public int maxMana_Base;
    public int mana;
    public RPGClass rpgClass;
    public int attackDMG_Base;
    public double attackSPD_Base;
    public double speed_Base;
    public double attackDMG_Items;
    public double attackSPD_Items;
    public int defense_Items;
    public int health_Items;
    public double speed_Items;
    public int mana_Items;

    public Map<RPGAttribute, Integer> totalAttributes() {
        return Map.of(RPGAttribute.STRENGTH, this.baseAttributes.getOrDefault((Object)RPGAttribute.STRENGTH, 0) + this.itemAttributes.getOrDefault((Object)RPGAttribute.STRENGTH, 0), RPGAttribute.DEXTERITY, this.baseAttributes.getOrDefault((Object)RPGAttribute.DEXTERITY, 0) + this.itemAttributes.getOrDefault((Object)RPGAttribute.DEXTERITY, 0), RPGAttribute.INTELLIGENCE, this.baseAttributes.getOrDefault((Object)RPGAttribute.INTELLIGENCE, 0) + this.itemAttributes.getOrDefault((Object)RPGAttribute.INTELLIGENCE, 0), RPGAttribute.VITALITY, this.baseAttributes.getOrDefault((Object)RPGAttribute.VITALITY, 0) + this.itemAttributes.getOrDefault((Object)RPGAttribute.VITALITY, 0), RPGAttribute.ENDURANCE, this.baseAttributes.getOrDefault((Object)RPGAttribute.ENDURANCE, 0) + this.itemAttributes.getOrDefault((Object)RPGAttribute.ENDURANCE, 0));
    }

    public void giveItem(RPGItem item) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        PlayerInventory inventory = player.getInventory();
        if (inventory.firstEmpty() == -1) {
            player.sendMessage("You didn't have enough space in your inventory to receive this item! Instead it was dropped on the ground.");
            player.getWorld().dropItemNaturally(player.getLocation(), item.build());
            return;
        }
        ItemStack itemStack = item.build();
        if (itemStack != null) {
            inventory.addItem(new ItemStack[]{itemStack});
            player.sendMessage("You received: " + String.valueOf(item.itemName));
        } else {
            player.sendMessage("Failed to create item: " + String.valueOf(item.itemName));
        }
    }

    public void giveItem(RPGItem item, int amount) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        PlayerInventory inventory = player.getInventory();
        if (inventory.firstEmpty() == -1) {
            player.sendMessage("You didn't have enough space in your inventory to receive this item! Instead it was dropped on the ground.");
            player.getWorld().dropItemNaturally(player.getLocation(), item.build(amount));
            return;
        }
        ItemStack itemStack = item.build(amount);
        if (itemStack != null) {
            inventory.addItem(new ItemStack[]{itemStack});
            player.sendMessage("You received: " + String.valueOf(item.itemName) + " x" + amount);
        } else {
            player.sendMessage("Failed to create item: " + String.valueOf(item.itemName));
        }
    }

    public RPGPlayer(UUID uuid) {
        this.uuid = uuid;
        this.ingameNick = Bukkit.getPlayer((UUID)uuid).getName();
    }

    public void levelUp() {
        ++this.level;
        this.maxExp = RPGPlayer.reqExpForLevel(this.level);
        this.exp = 0;
        ++this.skillPoints;
        this.attributePoints += 5;
        ++this.totalSkillPoints;
        this.totalAttributePoints += 5;
    }

    public void updateItemStats() {
        Player p = Bukkit.getPlayer((UUID)this.uuid);
        PlayerInventory i = p.getInventory();
        this.attackDMG_Items = 0.0;
        this.attackSPD_Items = 0.0;
        this.defense_Items = 0;
        this.health_Items = 0;
        this.speed_Items = 0.0;
        this.mana_Items = 0;
        ItemStack helmetItem = i.getItem(39);
        ItemStack chestplateItem = i.getItem(38);
        ItemStack leggingsItem = i.getItem(37);
        ItemStack bootsItem = i.getItem(36);
        ItemStack handItem = p.getItemInHand();
        ItemStack offHandItem = i.getItem(40);
        ArrayList<ItemStack> itemsToCount = new ArrayList<ItemStack>();
        itemsToCount.add(helmetItem);
        itemsToCount.add(chestplateItem);
        itemsToCount.add(leggingsItem);
        itemsToCount.add(bootsItem);
        itemsToCount.add(handItem);
        itemsToCount.add(offHandItem);
        NamespacedKey key_class = new NamespacedKey("rpgcore", "rpg_item_class");
        NamespacedKey key_level = new NamespacedKey("rpgcore", "rpg_item_level");
        NamespacedKey key_attack = new NamespacedKey("rpgcore", "rpg_item_attack");
        NamespacedKey key_attack_speed = new NamespacedKey("rpgcore", "rpg_item_attack_speed");
        NamespacedKey key_defense = new NamespacedKey("rpgcore", "rpg_item_defense");
        NamespacedKey key_health = new NamespacedKey("rpgcore", "rpg_item_health");
        NamespacedKey key_speed = new NamespacedKey("rpgcore", "rpg_item_speed");
        NamespacedKey key_mana = new NamespacedKey("rpgcore", "rpg_item_mana");
        NamespacedKey key_slot = new NamespacedKey("rpgcore", "rpg_item_slot");
        NamespacedKey key_crit_chance = new NamespacedKey("rpgcore", "rpg_item_crit_chance");
        for (ItemStack is : itemsToCount) {
            ItemMeta im;
            PersistentDataContainer pdc;
            String classStr;
            if (is == null || is.getType() == Material.AIR || !is.hasItemMeta()) continue;
            int slotInInv = -1;
            for (int x = 0; x < p.getInventory().getSize(); ++x) {
                if (p.getInventory().getItem(x) != is) continue;
                slotInInv = x;
                break;
            }
            if ((classStr = (String)(pdc = (im = is.getItemMeta()).getPersistentDataContainer()).getOrDefault(key_class, PersistentDataType.STRING, (Object)"")).isEmpty()) continue;
            RPGClass reqClass = RPGClass.valueOf(classStr);
            if (reqClass == this.rpgClass || reqClass == RPGClass.ANY) {
                int levelReq = (Integer)pdc.getOrDefault(key_level, PersistentDataType.INTEGER, (Object)0);
                if (this.level >= levelReq) {
                    int slotReq = (Integer)pdc.getOrDefault(key_slot, PersistentDataType.INTEGER, (Object)-1);
                    boolean matchesSlot = false;
                    if (slotReq == 0 && is.equals((Object)handItem)) {
                        matchesSlot = true;
                    } else if (slotReq == 1 && is.equals((Object)helmetItem)) {
                        matchesSlot = true;
                    } else if (slotReq == 2 && is.equals((Object)chestplateItem)) {
                        matchesSlot = true;
                    } else if (slotReq == 3 && is.equals((Object)leggingsItem)) {
                        matchesSlot = true;
                    } else if (slotReq == 4 && is.equals((Object)bootsItem)) {
                        matchesSlot = true;
                    } else if (slotReq == 5 && is.equals((Object)offHandItem)) {
                        matchesSlot = true;
                    } else if (slotReq == -1) {
                        matchesSlot = true;
                    }
                    if (matchesSlot) {
                        this.attackDMG_Items += ((Double)pdc.getOrDefault(key_attack, PersistentDataType.DOUBLE, (Object)0.0)).doubleValue();
                        this.attackSPD_Items += ((Double)pdc.getOrDefault(key_attack_speed, PersistentDataType.DOUBLE, (Object)0.0)).doubleValue();
                        this.defense_Items += ((Integer)pdc.getOrDefault(key_defense, PersistentDataType.INTEGER, (Object)0)).intValue();
                        this.health_Items += ((Integer)pdc.getOrDefault(key_health, PersistentDataType.INTEGER, (Object)0)).intValue();
                        this.speed_Items += ((Double)pdc.getOrDefault(key_speed, PersistentDataType.DOUBLE, (Object)0.0)).doubleValue();
                        this.mana_Items += ((Integer)pdc.getOrDefault(key_mana, PersistentDataType.INTEGER, (Object)0)).intValue();
                        this.critChance_Items += ((Double)pdc.getOrDefault(key_crit_chance, PersistentDataType.DOUBLE, (Object)0.0)).doubleValue();
                        continue;
                    }
                    Component displayName = is.getItemMeta().displayName();
                    if (displayName == null) {
                        displayName = Component.text((String)is.getType().name());
                    }
                    p.sendMessage(((TextComponent)((TextComponent)Component.text((String)"You cannot equip ").color((TextColor)NamedTextColor.RED)).append(displayName)).append(Component.text((String)" in this slot!").color((TextColor)NamedTextColor.RED)));
                    continue;
                }
                p.sendMessage(Component.text((String)"You are not high enough level to use one or more of your equipped items!").color((TextColor)NamedTextColor.RED));
                continue;
            }
            p.sendMessage(Component.text((String)"You are using one or more items from a different class than your own!").color((TextColor)NamedTextColor.RED));
        }
        if (handItem != null && handItem.getType() != Material.AIR && handItem.hasItemMeta()) {
            ItemMeta handMeta = handItem.getItemMeta();
            handMeta.removeAttributeModifier(Attribute.ATTACK_SPEED);
            handMeta.removeAttributeModifier(Attribute.ATTACK_DAMAGE);
            handMeta.addAttributeModifier(Attribute.ATTACK_SPEED, new AttributeModifier(new NamespacedKey("rpgcore", "attack_speed"), this.attackSPD_Items + this.attackSPD_Base, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND.getGroup()));
            handMeta.addAttributeModifier(Attribute.ATTACK_DAMAGE, new AttributeModifier(new NamespacedKey("rpgcore", "attack_damage"), 0.0, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND.getGroup()));
            handItem.setItemMeta(handMeta);
        }
        double totalSpeed = this.speed_Base + this.speed_Items;
        p.getAttribute(Attribute.MOVEMENT_SPEED).setBaseValue(totalSpeed);
    }

    private static int linearXP(int level) {
        return 50 + 50 * level;
    }

    private static int polynomialXP(int level, double pol) {
        return (int)(100.0 * Math.pow(level, pol));
    }

    private static int reqExpForLevel(int level) {
        if (level <= 5) {
            return RPGPlayer.linearXP(level);
        }
        if (level <= 15) {
            return RPGPlayer.polynomialXP(level, 1.3);
        }
        if (level <= 25) {
            return RPGPlayer.polynomialXP(level, 1.5);
        }
        if (level <= 35) {
            return RPGPlayer.polynomialXP(level, 1.7);
        }
        if (level <= 50) {
            return RPGPlayer.polynomialXP(level, 2.0);
        }
        double pol = 2.0;
        for (int i = 50; i <= level; i += 25) {
            pol += 0.25;
        }
        return RPGPlayer.polynomialXP(level, pol);
    }

    public void handleExpAdd(int experienceAfterDefeat) {
        this.exp += experienceAfterDefeat;
        int currentLevel = this.level;
        while (this.exp >= RPGPlayer.reqExpForLevel(currentLevel + 1)) {
            this.levelUp();
        }
    }
}

