/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.storage;

import io.github.bakedlibs.dough.blocks.BlockPosition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.simple.ItemDisplayId;

public class QuapticStorage
implements Listener {
    private static final Set<ConnectionGroupId> tickingGroupIds = new HashSet<ConnectionGroupId>();

    private static boolean isTickingGroup(Interaction interaction) {
        return new PersistentDataTraverser((PersistentDataHolder)interaction).getBoolean("isTicker");
    }

    public static void addGroup(ConnectionGroupId groupId) {
        tickingGroupIds.add(groupId);
    }

    public static void removeGroup(ConnectionGroupId groupId) {
        tickingGroupIds.remove(groupId);
    }

    @NotNull
    private static Collection<ConnectionGroupId> getTickingGroupIds(@NotNull Collection<Entity> entities) {
        return entities.stream().filter(Interaction.class::isInstance).map(Interaction.class::cast).filter(QuapticStorage::isTickingGroup).map(interaction -> new ConnectionGroupId(interaction.getUniqueId())).collect(Collectors.toList());
    }

    @NotNull
    private static Map<BlockPosition, ItemDisplayId> getProjectionIds(@NotNull Collection<Entity> entities) {
        return entities.stream().filter(Interaction.class::isInstance).map(Interaction.class::cast).map(interaction -> {
            ItemDisplayId displayId = new PersistentDataTraverser((PersistentDataHolder)interaction).getItemDisplayId("linked_block");
            return displayId == null ? null : (ItemDisplay)((Optional)displayId.get()).orElse(null);
        }).filter(Objects::nonNull).collect(Collectors.toMap(display -> new BlockPosition(display.getLocation()), display -> new ItemDisplayId(display.getUniqueId())));
    }

    @EventHandler
    public static void onEntityLoad(@NotNull EntitiesLoadEvent event) {
        tickingGroupIds.addAll(QuapticStorage.getTickingGroupIds(event.getEntities()));
        ComplexMultiblock.CACHE.putAll(QuapticStorage.getProjectionIds(event.getEntities()));
    }

    @EventHandler
    public static void onEntityUnload(@NotNull EntitiesUnloadEvent event) {
        tickingGroupIds.removeAll(QuapticStorage.getTickingGroupIds(event.getEntities()));
        ComplexMultiblock.CACHE.entrySet().removeIf(entry -> event.getEntities().contains(((Optional)((ItemDisplayId)entry.getValue()).get()).orElse(null)));
    }

    public static Set<ConnectionGroupId> getTickingGroupIds() {
        return tickingGroupIds;
    }
}

