/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.schedulers;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.panels.info.implementation.PointInfoPanel;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public final class PointPanelUpdateScheduler {
    private static final Map<InfoPanelId, ConnectionPointId> panelsToTick = new HashMap<InfoPanelId, ConnectionPointId>();

    private PointPanelUpdateScheduler() {
    }

    public static void scheduleUpdate(@Nullable InfoPanelId panelId, @NotNull ConnectionPointId pointId) {
        if (panelId != null) {
            panelsToTick.put(panelId, pointId);
        }
    }

    public static void tick() {
        panelsToTick.forEach((panelId, pointId) -> {
            if (((Optional)panelId.get()).isPresent() && ((Optional)pointId.get()).isPresent()) {
                new PointInfoPanel((InfoPanelId)panelId, (ConnectionPointId)pointId).update();
            }
        });
        panelsToTick.clear();
    }
}

