/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.implementation.attachments.ProgressBlock;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class ProgressInfoPanel
extends BlockInfoPanel {
    public ProgressInfoPanel(@NotNull Location location, ConnectionGroupId groupId) {
        super(location, groupId);
    }

    public ProgressInfoPanel(@NotNull InfoPanelId panelId, ConnectionGroupId groupId) {
        super(panelId, groupId);
    }

    @Override
    protected InfoPanelContainer buildPanelContainer(@NotNull Location location) {
        return new InfoPanelBuilder(location.clone().toCenterLocation().add(this.getOffset()), 0.4f).addAttribute("progressBar", false).build();
    }

    @Override
    public void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        this.container.setText("progressBar", ProgressBlock.progressBar(group.get()));
    }
}

