/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.config.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.config.ConfigPanel;
import org.metamechanists.quaptics.panels.config.ConfigPanelBuilder;
import org.metamechanists.quaptics.panels.config.ConfigPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Utils;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class LaunchpadConfigPanel
extends ConfigPanel {
    public LaunchpadConfigPanel(@NotNull Location location, ConnectionGroupId groupId, float rotationY) {
        super(groupId, location, rotationY);
    }

    public LaunchpadConfigPanel(@NotNull ConfigPanelId id, ConnectionGroupId groupId) {
        super(id, groupId);
    }

    @Override
    protected ConfigPanelContainer buildPanelContainer(@NotNull ConnectionGroupId groupId, @NotNull Location location, float rotationY) {
        return new ConfigPanelBuilder(groupId, location.clone().add(this.getOffset()), 0.3f, rotationY).addAttribute("velocityX", "&fVelocity (x)").addAttribute("velocityY", "&fVelocity (y)").addAttribute("velocityZ", "&fVelocity (z)").build();
    }

    @Override
    public void interact(@NotNull Player player, @NotNull Location location, String name, String type) {
        Optional<Vector> velocity = BlockStorageAPI.getVector(location, "QP_VELOCITY");
        if (velocity.isEmpty()) {
            return;
        }
        int increment = "add".equals(type) ? 1 : -1;
        velocity.get().add(new Vector("velocityX".equals(name) ? increment : 0, "velocityY".equals(name) ? increment : 0, "velocityZ".equals(name) ? increment : 0));
        Utils.clampToRange(velocity.get(), -10.0f, 10.0f);
        BlockStorageAPI.set(location, "QP_VELOCITY", velocity.get());
        this.update();
    }

    @Override
    protected void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        Optional<Vector> velocity = BlockStorageAPI.getVector(location.get(), "QP_VELOCITY");
        if (velocity.isEmpty()) {
            return;
        }
        this.container.setValue("velocityX", Lore.twoWayProgressBar(velocity.get().getX(), 10.0, "&c", "&a", "&7"));
        this.container.setValue("velocityY", Lore.twoWayProgressBar(velocity.get().getY(), 10.0, "&c", "&a", "&7"));
        this.container.setValue("velocityZ", Lore.twoWayProgressBar(velocity.get().getZ(), 10.0, "&c", "&a", "&7"));
    }

    @Override
    protected Vector getOffset() {
        return new Vector(0.0, 0.2, 0.0);
    }
}

