/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.dough.blocks;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public final class BlockPosition {
    private final WeakReference<World> world;
    private final long position;

    public BlockPosition(@Nonnull World world, long position) {
        this.world = new WeakReference<World>(world);
        this.position = position;
    }

    public BlockPosition(@Nonnull World world, int x, int y, int z) {
        this.world = new WeakReference<World>(world);
        this.position = BlockPosition.getAsLong(x, y, z);
    }

    public BlockPosition(@Nonnull Block b) {
        this(b.getWorld(), b.getX(), b.getY(), b.getZ());
    }

    public BlockPosition(@Nonnull Location l) {
        this(l.getWorld(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    @Nonnull
    public World getWorld() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("The reference of this BlockPositions world has been cleared");
        }
        return ref;
    }

    public long getPosition() {
        return this.position;
    }

    public int getX() {
        return (int)(this.position >> 38);
    }

    public int getY() {
        return (int)(this.position << 52 >> 52);
    }

    public int getZ() {
        return (int)(this.position << 26 >> 38);
    }

    @Nonnull
    public Block getBlock() {
        return this.getChunk().getBlock(this.getX() & 0xF, this.getY(), this.getZ() & 0xF);
    }

    @Nonnull
    public Chunk getChunk() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("Cannot get Chunk when the world isn't loaded");
        }
        return ref.getChunkAt(this.getChunkX(), this.getChunkZ());
    }

    public int getChunkX() {
        return this.getX() >> 4;
    }

    public int getChunkZ() {
        return this.getZ() >> 4;
    }

    @Nonnull
    public Location toLocation() {
        return new Location((World)this.world.get(), (double)this.getX(), (double)this.getY(), (double)this.getZ());
    }

    public static long getAsLong(int x, int y, int z) {
        return (long)(x & 0x3FFFFFF) << 38 | (long)(z & 0x3FFFFFF) << 12 | (long)(y & 0xFFF);
    }

    public static long getAsLong(@Nonnull Location loc) {
        return BlockPosition.getAsLong(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public boolean equals(Object o) {
        if (o instanceof BlockPosition) {
            BlockPosition pos = (BlockPosition)o;
            if (pos.world.get() == null) {
                return false;
            }
            return this.getWorld().getUID().equals(pos.getWorld().getUID()) && this.position == pos.position;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        World ref = (World)this.world.get();
        int result = 0;
        result += prime * (ref == null ? 0 : ref.hashCode());
        return result += prime * Long.hashCode(this.position);
    }

    public String toString() {
        World w = (World)this.world.get();
        String worldName = w != null ? w.getName() : "<no reference>";
        return String.format("BlockPosition(world=%s, x=%d, y=%d, z=%d, position=%d)", worldName, this.getX(), this.getY(), this.getZ(), this.getPosition());
    }
}

