/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools.multiblockwand;

import io.github.bakedlibs.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.implementation.tools.multiblockwand.MultiblockWand;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.simple.ItemDisplayId;

public class MultiblockWandListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void placeEvent(@NotNull BlockPlaceEvent event) {
        if (MultiblockWandListener.shouldUpdateProjection(event.getBlock())) {
            Slimefun.runSync(() -> MultiblockWandListener.updateProjection(event.getBlock()), (long)1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void interactEvent(@NotNull PlayerInteractEntityEvent event) {
        Entity clickedEntity = event.getRightClicked();
        if (clickedEntity.getType() != EntityType.INTERACTION) {
            return;
        }
        Block block = clickedEntity.getLocation().getBlock();
        ItemDisplayId id = ComplexMultiblock.CACHE.get(new BlockPosition(block));
        if (id == null || ((Optional)id.get()).isEmpty()) {
            return;
        }
        ItemStack stack = ((ItemDisplay)((Optional)id.get()).get()).getItemStack();
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)stack);
        if (stack == null) {
            return;
        }
        ItemStack mainItem = event.getPlayer().getInventory().getItemInMainHand();
        ItemStack offItem = event.getPlayer().getInventory().getItemInOffHand();
        if (block.isEmpty() && (SlimefunUtils.isItemSimilar((ItemStack)mainItem, (ItemStack)stack, (boolean)true) || SlimefunUtils.isItemSimilar((ItemStack)offItem, (ItemStack)stack, (boolean)true)) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)event.getPlayer(), block, Interaction.PLACE_BLOCK)) {
            MultiblockWandListener.easyPlaceBlock(event, block, stack, mainItem, slimefunItem, offItem);
            return;
        }
        if (SlimefunItem.getByItem((ItemStack)mainItem) instanceof MultiblockWand || SlimefunItem.getByItem((ItemStack)offItem) instanceof MultiblockWand) {
            String blockName = slimefunItem != null ? slimefunItem.getItemName() : ChatUtils.humanize((String)stack.getType().name());
            Language.sendLanguageMessage(event.getPlayer(), "multiblock.block-name", blockName);
        }
        Slimefun.runSync(() -> MultiblockWandListener.updateProjection(block), (long)1L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void breakEvent(@NotNull BlockBreakEvent event) {
        if (MultiblockWandListener.shouldUpdateProjection(event.getBlock())) {
            Slimefun.runSync(() -> MultiblockWandListener.updateProjection(event.getBlock()), (long)1L);
        }
    }

    public static void easyPlaceBlock(@NotNull PlayerInteractEntityEvent event, Block block, ItemStack stack, ItemStack mainItem, SlimefunItem slimefunItem, ItemStack offItem) {
        block.setType(stack.getType());
        boolean mainHand = SlimefunUtils.isItemSimilar((ItemStack)mainItem, (ItemStack)stack, (boolean)true);
        if (slimefunItem != null) {
            BlockPlaceEvent placeEvent = new BlockPlaceEvent(block, block.getState(), block, stack, event.getPlayer(), true, mainHand ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            BlockStorage.store((Block)block, (String)slimefunItem.getId());
            slimefunItem.callItemHandler(BlockPlaceHandler.class, handler -> handler.onPlayerPlace(placeEvent));
        }
        (mainHand ? mainItem : offItem).subtract();
        Slimefun.runSync(() -> MultiblockWandListener.updateProjection(block), (long)1L);
    }

    public static boolean shouldUpdateProjection(Block block) {
        return ComplexMultiblock.CACHE.containsKey(new BlockPosition(block));
    }

    public static void updateProjection(Block block) {
        BlockPosition position = new BlockPosition(block);
        ItemDisplayId id = ComplexMultiblock.CACHE.get(position);
        if (id == null) {
            return;
        }
        ((Optional)id.get()).ifPresent(itemDisplay -> {
            boolean correct;
            ItemStack stack = itemDisplay.getItemStack();
            if (stack == null) {
                return;
            }
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)stack);
            if (slimefunItem != null) {
                correct = BlockStorage.check((Block)block, (String)slimefunItem.getId());
            } else {
                boolean bl = correct = stack.getType() == block.getType();
            }
            if (block.isEmpty()) {
                itemDisplay.setGlowColorOverride(ComplexMultiblock.EMPTY_COLOR);
            } else {
                itemDisplay.setGlowColorOverride(correct ? ComplexMultiblock.RIGHT_MATERIAL_COLOR : ComplexMultiblock.WRONG_MATERIAL_COLOR);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public static void scrollEvent(@NotNull PlayerItemHeldEvent event) {
        ItemStack heldItem = event.getPlayer().getInventory().getItem(event.getPreviousSlot());
        if (SlimefunItem.getByItem((ItemStack)heldItem) instanceof MultiblockWand) {
            MultiblockWand.removeProjection(heldItem);
        }
    }
}

