/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers.turrets;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public abstract class Turret
extends ConnectedBlock
implements PowerAnimatedBlock {
    private static final int ARBITRARILY_LARGE_NUMBER = 9999999;
    private final Vector inputLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    protected Turret(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.55f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_PLAYER", player.getUniqueId());
        return new ModelBuilder().add("plate", new ModelCuboid().material(Material.POLISHED_ANDESITE).size(0.6f)).add("barrel", new ModelCuboid().material(Material.GRAY_CONCRETE)).add("power1", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).size(0.6f, 0.2f, 1.1f).location(0.0f, -0.25f, 0.0f)).add("power2", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).size(1.1f, 0.2f, 0.6f).location(0.0f, -0.25f, 0.0f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Turret.formatPointLocation(player, location, this.inputLocation)));
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    protected void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            this.retarget(location);
            this.shoot(location);
        }
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        BlockStorageAPI.set(location, "QP_POWERED", false);
        Optional<Link> inputLink = Turret.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
        if (this.settings.isOperational(inputLink)) {
            BlockStorageAPI.set(location, "QP_POWERED", true);
        }
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "power1", powered);
        this.brightnessAnimation(location, "power2", powered);
    }

    @NotNull
    private static Matrix4f getBarrelMatrix(@NotNull Location from, Location to) {
        Vector3f barrelDirection = TransformationUtils.getDirection(from, to);
        return new ModelLine().to(barrelDirection.mul(0.8f)).thickness(0.2f).getMatrix();
    }

    private static void updateBarrelTransformation(Location location, LivingEntity target) {
        Turret.getDisplay(location, "barrel").ifPresent(value -> value.setTransformationMatrix(Turret.getBarrelMatrix(location.toCenterLocation(), target.getEyeLocation())));
    }

    private static void setTarget(@NotNull Location location, @NotNull Entity entity) {
        BlockStorageAPI.set(location, "QP_TARGET", entity.getUniqueId());
    }

    private static void clearTarget(Location location) {
        BlockStorageAPI.set(location, "QP_TARGET", (UUID)null);
    }

    private static Optional<LivingEntity> getTarget(Location location) {
        Optional<UUID> targetUuid = BlockStorageAPI.getUuid(location, "QP_TARGET");
        return targetUuid.map(uuid -> (LivingEntity)Bukkit.getEntity((UUID)uuid));
    }

    private static Optional<LivingEntity> getClosestEntity(@NotNull Collection<? extends Entity> entities, Location location) {
        LivingEntity target = null;
        double targetDistance = 9999999.0;
        for (Entity entity : entities) {
            double distance = entity.getLocation().distance(location.toCenterLocation());
            if (!(distance < targetDistance)) continue;
            target = (LivingEntity)entity;
            targetDistance = distance;
        }
        return Optional.ofNullable(target);
    }

    private void retarget(@NotNull Location location) {
        if (BlockStorageAPI.hasData(location, "QP_TARGET")) {
            return;
        }
        Collection entities = location.getWorld().getNearbyEntities(location, (double)this.settings.getRange(), (double)this.settings.getRange(), (double)this.settings.getRange(), entity -> this.settings.getTargets().contains(entity.getSpawnCategory()) && entity instanceof LivingEntity && entity.getLocation().distance(location) < (double)this.settings.getRange());
        if (entities.isEmpty()) {
            return;
        }
        Optional<LivingEntity> closestEntity = Turret.getClosestEntity(entities, location);
        closestEntity.ifPresent(livingEntity -> Turret.setTarget(location, (Entity)livingEntity));
    }

    private void shoot(Location location) {
        Optional<LivingEntity> target = Turret.getTarget(location);
        if (target.isEmpty() || target.get().isDead() || location.toCenterLocation().distance(target.get().getLocation()) > (double)this.settings.getRange()) {
            Turret.clearTarget(location);
            return;
        }
        Optional<UUID> uuid = BlockStorageAPI.getUuid(location, "QP_PLAYER");
        if (uuid.isEmpty()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)uuid.get());
        if (player == null) {
            return;
        }
        if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)player, target.get().getLocation(), Interaction.ATTACK_ENTITY)) {
            return;
        }
        Turret.updateBarrelTransformation(location, target.get());
        this.createProjectile(player, location, target.get().getEyeLocation());
        if (this.shouldDamage()) {
            target.get().damage(this.settings.getDamage());
            target.get().setVelocity(Vector.fromJOML((Vector3f)TransformationUtils.getDisplacement(location, target.get().getEyeLocation()).mul(0.2f)));
        }
    }

    protected abstract boolean shouldDamage();

    protected abstract void createProjectile(@NotNull Player var1, @NotNull Location var2, Location var3);
}

