/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.InfoPanelBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.implementation.ChargerInfoPanel;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class Charger
extends ConnectedBlock
implements InfoPanelBlock,
ItemHolderBlock,
PowerAnimatedBlock {
    public static final Settings CHARGER_1_SETTINGS = Settings.builder().tier(Tier.PRIMITIVE).build();
    public static final Settings CHARGER_2_SETTINGS = Settings.builder().tier(Tier.BASIC).minFrequency(2.0).build();
    public static final Settings CHARGER_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).minFrequency(100.0).build();
    public static final Settings CHARGER_4_SETTINGS = Settings.builder().tier(Tier.ADVANCED).minFrequency(3000.0).build();
    public static final SlimefunItemStack CHARGER_1 = new SlimefunItemStack("QP_CHARGER_1", Material.POLISHED_DEEPSLATE_SLAB, "&7Charger &fI", Lore.create(CHARGER_1_SETTINGS, "&7\u25cf Charges Quaptic items", "&7\u25cf &eRight Click &7with a chargeable item to insert"));
    public static final SlimefunItemStack CHARGER_2 = new SlimefunItemStack("QP_CHARGER_2", Material.POLISHED_DEEPSLATE_SLAB, "&7Charger &fII", Lore.create(CHARGER_2_SETTINGS, "&7\u25cf Charges Quaptic items", "&7\u25cf &eRight Click &7with a chargeable item to insert"));
    public static final SlimefunItemStack CHARGER_3 = new SlimefunItemStack("QP_CHARGER_3", Material.POLISHED_DEEPSLATE_SLAB, "&7Charger &fIII", Lore.create(CHARGER_3_SETTINGS, "&7\u25cf Charges Quaptic items", "&7\u25cf &eRight Click &7with a chargeable item to insert"));
    public static final SlimefunItemStack CHARGER_4 = new SlimefunItemStack("QP_CHARGER_4", Material.POLISHED_DEEPSLATE_SLAB, "&7Charger &fIV", Lore.create(CHARGER_4_SETTINGS, "&7\u25cf Charges Quaptic items", "&7\u25cf &eRight Click &7with a chargeable item to insert"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public Charger(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.6f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("mainTop", new ModelCuboid().block(Material.POLISHED_DEEPSLATE_SLAB.createBlockData("[type=top]")).location(0.0f, 0.35f, 0.0f).size(0.6f, 0.3f, 0.6f)).add("mainBottom", new ModelCuboid().block(Material.POLISHED_DEEPSLATE_SLAB.createBlockData("[type=bottom]")).location(0.0f, -0.35f, 0.0f).size(0.6f, 0.3f, 0.6f)).add("glassTop", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, 0.35f, 0.0f).size(0.4f, 0.15f, 0.4f)).add("glassBottom", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, -0.35f, 0.0f).size(0.4f, 0.15f, 0.4f)).add("item", new ModelItem().facing(player.getFacing()).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Charger.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
        this.onPlaceInfoPanelBlock(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakInfoPanelBlock(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onTick10(@NotNull ConnectionGroup group, @NotNull Location location) {
        boolean hasItem = BlockStorageAPI.getBoolean(location, "QP_IS_HOLDING_ITEM");
        this.setPanelHidden(group, !hasItem);
        if (!hasItem) {
            return;
        }
        Optional<ItemStack> stack = ItemHolderBlock.getStack(group, "item");
        if (stack.isEmpty()) {
            return;
        }
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)stack.get());
        if (!(slimefunItem instanceof QuapticChargeableItem)) {
            return;
        }
        QuapticChargeableItem chargeableItem = (QuapticChargeableItem)slimefunItem;
        Optional<Link> inputLink = Charger.getLink(group, "input");
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink)) {
            return;
        }
        ItemStack newStack = chargeableItem.chargeItem(inputLink.get(), stack.get(), 10);
        ItemHolderBlock.insertItem(location, "item", newStack);
        this.updatePanel(group);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> inputLink = Charger.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        if (!(SlimefunItem.getByItem((ItemStack)stack) instanceof QuapticChargeableItem)) {
            Language.sendLanguageMessage(player, "charger.not-chargeable", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        QuapticChargeableItem.updateLore(stack);
        return Optional.of(stack);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "glassTop", powered);
        this.brightnessAnimation(location, "glassBottom", powered);
    }

    @Override
    public BlockInfoPanel createPanel(Location location, @NotNull ConnectionGroup group) {
        return new ChargerInfoPanel(location, group.getId());
    }

    @Override
    public BlockInfoPanel getPanel(InfoPanelId panelId, ConnectionGroupId groupId) {
        return new ChargerInfoPanel(panelId, groupId);
    }
}

