/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.base;

import com.destroystokyo.paper.ParticleBuilder;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.transformations.TransformationUtils;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.simple.DisplayGroupId;

public abstract class QuapticBlock
extends SlimefunItem {
    private static final int BURNOUT_EXPLODE_VOLUME = 2;
    private static final float BURNOUT_EXPLODE_PITCH = 1.2f;
    protected final Settings settings;

    protected QuapticBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe);
        this.settings = settings;
        this.addItemHandler(new ItemHandler[]{this.onRightClick()});
    }

    @OverridingMethodsMustInvokeSuper
    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                Player player = event.getPlayer();
                Location location = event.getBlock().getLocation();
                DisplayGroup displayGroup = QuapticBlock.this.initModel(location, player);
                QuapticBlock.setId(displayGroup, location);
                event.getBlock().setType(QuapticBlock.this.getBaseMaterial());
                QuapticBlock.this.initBlockStorage(location, player);
                QuapticBlock.this.onPlace(event);
            }
        }, new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
                Location location = event.getBlock().getLocation();
                QuapticBlock.this.onBreak(location);
                QuapticBlock.getDisplayGroup(location.clone()).ifPresent(DisplayGroup::remove);
                event.getBlock().setType(Material.AIR);
            }
        }, new BlockTicker(){

            public void tick(Block block, SlimefunItem item, Config data) {
                QuapticBlock.this.onSlimefunTick(block, item, data);
            }

            public boolean isSynchronized() {
                return true;
            }
        }});
    }

    @ParametersAreNonnullByDefault
    protected abstract DisplayGroup initModel(Location var1, Player var2);

    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
    }

    protected void onPlace(@NotNull BlockPlaceEvent event) {
    }

    protected void onBreak(@NotNull Location location) {
    }

    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        return false;
    }

    protected boolean onShiftRightClick(@NotNull Location location, @NotNull Player player) {
        return false;
    }

    @NotNull
    private BlockUseHandler onRightClick() {
        return event -> {
            Block block = event.getClickedBlock().orElse(null);
            if (block == null) {
                return;
            }
            if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)event.getPlayer(), block.getLocation(), Interaction.INTERACT_BLOCK)) {
                return;
            }
            if (event.getPlayer().isSneaking()) {
                if (this.onShiftRightClick(block.getLocation(), event.getPlayer())) {
                    event.cancel();
                }
            } else if (this.onRightClick(block.getLocation(), event.getPlayer())) {
                event.cancel();
            }
        };
    }

    protected void onSlimefunTick(@NotNull Block block, SlimefunItem item, Config data) {
    }

    private static void setId(@NotNull DisplayGroup displayGroup, Location location) {
        BlockStorageAPI.set(location, "display-uuid", displayGroup.getParentUUID());
    }

    @OverridingMethodsMustInvokeSuper
    protected void burnout(Location location) {
        QuapticBlock.getDisplayGroup(location).ifPresent(displayGroup -> {
            displayGroup.getDisplays().values().forEach(Entity::remove);
            displayGroup.remove();
        });
        BlockStorageAPI.removeData(location);
        location.getBlock().setBlockData(Material.AIR.createBlockData());
        location.getWorld().playSound(location.toCenterLocation(), Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 1.2f);
        new ParticleBuilder(Particle.FLASH).location(location.toCenterLocation()).count(3).spawn();
    }

    @NotNull
    protected Material getBaseMaterial() {
        return Material.STRUCTURE_VOID;
    }

    @NotNull
    private static Vector rotateVectorByYaw(float yaw, @NotNull Vector vector) {
        double rotationAngle = TransformationUtils.yawToCardinalDirection(yaw);
        return vector.clone().rotateAroundY(rotationAngle);
    }

    @NotNull
    protected static Location formatPointLocation(@NotNull Player player, @NotNull Location location, @NotNull Vector relativeLocation) {
        Vector newRelativeLocation = QuapticBlock.rotateVectorByYaw(player.getEyeLocation().getYaw(), relativeLocation);
        return location.toCenterLocation().clone().add(newRelativeLocation);
    }

    @NotNull
    protected static Location formatPointLocation(float yaw, @NotNull Location location, @NotNull Vector relativeLocation) {
        Vector newRelativeLocation = QuapticBlock.rotateVectorByYaw(yaw, relativeLocation);
        return location.toCenterLocation().clone().add(newRelativeLocation);
    }

    protected static Optional<DisplayGroupId> getDisplayGroupId(Location location) {
        return BlockStorageAPI.getDisplayGroupId(location, "display-uuid");
    }

    public static Optional<DisplayGroup> getDisplayGroup(Location location) {
        return QuapticBlock.getDisplayGroupId(location).map(displayGroupId -> DisplayGroup.fromUUID(displayGroupId.getUUID()));
    }

    public static Optional<Display> getDisplay(Location location, String name) {
        return QuapticBlock.getDisplayGroup(location).map(displayGroup -> displayGroup.getDisplays().get(name));
    }

    protected static Optional<BlockDisplay> getBlockDisplay(Location location, String name) {
        Optional<BlockDisplay> optional;
        Display display;
        Optional<Display> display2 = QuapticBlock.getDisplay(location, name);
        if (display2.isPresent() && (display = display2.get()) instanceof BlockDisplay) {
            BlockDisplay blockDisplay = (BlockDisplay)display;
            optional = Optional.of(blockDisplay);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public static Optional<ItemDisplay> getItemDisplay(Location location, String name) {
        Optional<ItemDisplay> optional;
        Display display;
        Optional<Display> display2 = QuapticBlock.getDisplay(location, name);
        if (display2.isPresent() && (display = display2.get()) instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)display;
            optional = Optional.of(itemDisplay);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

