/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.utils;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.Nullable;

public final class SlimefunIsDumbUtils {
    public static Optional<MultiBlockMachine> getMultiblockMachine(Block block) {
        for (MultiBlock multiBlock : Slimefun.getRegistry().getMultiBlocks()) {
            SlimefunItem slimefunItem = multiBlock.getSlimefunItem();
            if (!(slimefunItem instanceof MultiBlockMachine)) continue;
            MultiBlockMachine multiBlockMachine = (MultiBlockMachine)slimefunItem;
            Block center = block.getRelative(multiBlock.getTriggerBlock());
            if (!SlimefunIsDumbUtils.compareMaterials(center, multiBlock.getStructure(), multiBlock.isSymmetric())) continue;
            return Optional.of(multiBlockMachine);
        }
        return Optional.empty();
    }

    @ParametersAreNonnullByDefault
    private static boolean compareMaterials(Block block, Material[] blocks, boolean onlyTwoWay) {
        BlockFace[] blockFaceArray;
        if (!SlimefunIsDumbUtils.compareMaterialsVertical(block, blocks[1], blocks[4], blocks[7])) {
            return false;
        }
        if (onlyTwoWay) {
            BlockFace[] blockFaceArray2 = new BlockFace[2];
            blockFaceArray2[0] = BlockFace.NORTH;
            blockFaceArray = blockFaceArray2;
            blockFaceArray2[1] = BlockFace.EAST;
        } else {
            BlockFace[] blockFaceArray3 = new BlockFace[4];
            blockFaceArray3[0] = BlockFace.NORTH;
            blockFaceArray3[1] = BlockFace.EAST;
            blockFaceArray3[2] = BlockFace.SOUTH;
            blockFaceArray = blockFaceArray3;
            blockFaceArray3[3] = BlockFace.WEST;
        }
        BlockFace[] directions = blockFaceArray;
        return Arrays.stream(directions).anyMatch(direction -> SlimefunIsDumbUtils.compareMaterialsVertical(block.getRelative(direction), blocks[0], blocks[3], blocks[6]) && SlimefunIsDumbUtils.compareMaterialsVertical(block.getRelative(direction.getOppositeFace()), blocks[2], blocks[5], blocks[8]));
    }

    private static boolean compareMaterialsVertical(Block block, @Nullable Material top, @Nullable Material center, @Nullable Material bottom) {
        return !(center != null && !SlimefunIsDumbUtils.equals(block.getType(), center) || top != null && !SlimefunIsDumbUtils.equals(block.getRelative(BlockFace.UP).getType(), top) || bottom != null && !SlimefunIsDumbUtils.equals(block.getRelative(BlockFace.DOWN).getType(), bottom));
    }

    @ParametersAreNonnullByDefault
    private static boolean equals(Material a, Material b) {
        return a == b || MultiBlock.getSupportedTags().stream().anyMatch(tag -> tag.isTagged((Keyed)a) && tag.isTagged((Keyed)b));
    }

    private SlimefunIsDumbUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

