/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.dough.protection.modules;

import java.util.Optional;
import javax.annotation.Nonnull;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import nl.rutgerkok.blocklocker.BlockLockerPlugin;
import nl.rutgerkok.blocklocker.profile.PlayerProfile;
import nl.rutgerkok.blocklocker.profile.Profile;
import nl.rutgerkok.blocklocker.protection.Protection;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.metamechanists.quaptics.metalib.dough.protection.ActionType;
import org.metamechanists.quaptics.metalib.dough.protection.Interaction;
import org.metamechanists.quaptics.metalib.dough.protection.ProtectionModule;

public class BlockLockerProtectionModule
implements ProtectionModule {
    private BlockLockerPlugin api;
    private final Plugin plugin;

    public BlockLockerProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.api = BlockLockerAPIv2.getPlugin();
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (action.getType() != ActionType.BLOCK) {
            return true;
        }
        Optional protection = this.api.getProtectionFinder().findProtection(l.getBlock());
        if (protection.isPresent()) {
            PlayerProfile profile = this.api.getProfileFactory().fromNameAndUniqueId(p.getName(), Optional.of(p.getUniqueId()));
            return ((Protection)protection.get()).isAllowed((Profile)profile);
        }
        return true;
    }
}

