/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.dough.inventory;

import java.util.HashMap;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.quaptics.metalib.dough.items.ItemUtils;

public final class InvUtils {
    private InvUtils() {
    }

    public static boolean hasEmptySlot(@Nonnull Inventory inv) {
        return inv.firstEmpty() != 1;
    }

    public static boolean isEmpty(@Nonnull Inventory inv) {
        for (ItemStack item : inv) {
            if (item == null || item.getType().isAir()) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidStackSize(@Nonnull ItemStack stack, @Nonnull ItemStack item, @Nonnull Inventory inv) {
        int newStackSize = stack.getAmount() + item.getAmount();
        return newStackSize <= stack.getMaxStackSize() && newStackSize <= inv.getMaxStackSize();
    }

    public static boolean isItemAllowed(@Nonnull Material itemType, @Nonnull InventoryType inventoryType) {
        switch (inventoryType) {
            case LECTERN: {
                return itemType == Material.WRITABLE_BOOK || itemType == Material.WRITTEN_BOOK;
            }
            case SHULKER_BOX: {
                return itemType != Material.SHULKER_BOX && !itemType.name().endsWith("_SHULKER_BOX");
            }
        }
        return true;
    }

    public static boolean fits(@Nonnull Inventory inv, @Nonnull ItemStack item, int ... slots) {
        if (!InvUtils.isItemAllowed(item.getType(), inv.getType())) {
            return false;
        }
        if (slots.length == 0) {
            slots = IntStream.range(0, inv.getSize()).toArray();
        }
        for (int slot : slots) {
            ItemStack stack = inv.getItem(slot);
            if (stack == null || stack.getType() == Material.AIR) {
                return true;
            }
            if (!InvUtils.isValidStackSize(stack, item, inv) || !ItemUtils.canStack(stack, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean fitAll(@Nonnull Inventory inv, @Nonnull ItemStack[] items, int ... slots) {
        if (slots.length == 0) {
            slots = IntStream.range(0, inv.getSize()).toArray();
        }
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            return InvUtils.fits(inv, items[0], slots);
        }
        HashMap<Integer, ItemStack> cache = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            boolean resolved = false;
            for (int slot : slots) {
                ItemStack stack = cache.getOrDefault(slot, inv.getItem(slot));
                if (stack == null || stack.getType() == Material.AIR) {
                    cache.put(slot, items[i]);
                    resolved = true;
                } else if (InvUtils.isValidStackSize(stack, item, inv) && ItemUtils.canStack(stack, item)) {
                    ItemStack clone = stack.clone();
                    clone.setAmount(stack.getAmount() + item.getAmount());
                    cache.put(slot, clone);
                    resolved = true;
                }
                if (resolved) break;
            }
            if (resolved) continue;
            return false;
        }
        return true;
    }

    public static boolean removeItem(@Nonnull Inventory inv, int amount, boolean replaceConsumables, @Nonnull Predicate<ItemStack> predicate) {
        int removed = 0;
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            ItemStack item = inv.getItem(slot);
            if (item == null || !predicate.test(item)) continue;
            if (item.getAmount() + removed >= amount) {
                ItemUtils.consumeItem(item, amount - removed, replaceConsumables);
                return true;
            }
            if (item.getAmount() <= 0) continue;
            removed += item.getAmount();
            ItemUtils.consumeItem(item, item.getAmount(), replaceConsumables);
        }
        return false;
    }
}

