/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.tools;

import io.github.bakedlibs.dough.common.ChatColors;
import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ChargeHolder;
import org.metamechanists.quaptics.implementation.blocks.consumers.Charger;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.utils.Keys;

public abstract class QuapticChargeableItem
extends SlimefunItem
implements ChargeHolder {
    protected final Settings settings;

    protected QuapticChargeableItem(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe);
        this.settings = settings;
        this.addItemHandler(new ItemHandler[]{this.onItemUse()});
    }

    @NotNull
    private ItemUseHandler onItemUse() {
        return event -> {
            if (event.getSlimefunBlock().isPresent() && event.getSlimefunBlock().get() instanceof Charger) {
                return;
            }
            event.cancel();
            this.onUseItem(event);
        };
    }

    protected void onUseItem(PlayerRightClickEvent event) {
    }

    private static Optional<QuapticChargeableItem> fromStack(@Nullable ItemStack stack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)stack);
        if (!(slimefunItem instanceof QuapticChargeableItem)) {
            return Optional.empty();
        }
        QuapticChargeableItem chargeableItem = (QuapticChargeableItem)slimefunItem;
        return Optional.of(chargeableItem);
    }

    public static double getCapacity(@NotNull ItemStack itemStack) {
        Optional<QuapticChargeableItem> item = QuapticChargeableItem.fromStack(itemStack);
        return item.map(quapticChargeableItem -> quapticChargeableItem.settings.getChargeCapacity()).orElse(0.0);
    }

    public static double getCharge(@NotNull ItemStack stack) {
        return PersistentDataAPI.getDouble((PersistentDataHolder)stack.getItemMeta(), Keys.CHARGE, 0.0);
    }

    protected static void setCharge(@NotNull ItemStack stack, double newCharge) {
        ItemMeta meta = stack.getItemMeta();
        PersistentDataAPI.setDouble((PersistentDataHolder)meta, Keys.CHARGE, newCharge);
        stack.setItemMeta(meta);
    }

    @NotNull
    public ItemStack chargeItem(double chargeRate, @NotNull ItemStack itemStack, int tickInterval) {
        if (itemStack.getItemMeta() == null) {
            return itemStack;
        }
        Optional<QuapticChargeableItem> item = QuapticChargeableItem.fromStack(itemStack);
        if (item.isEmpty()) {
            return itemStack;
        }
        double newCharge = this.stepCharge(item.get().settings, QuapticChargeableItem.getCharge(itemStack), chargeRate * ((double)tickInterval / 20.0));
        QuapticChargeableItem.setCharge(itemStack, newCharge);
        return itemStack;
    }

    @NotNull
    public ItemStack chargeItem(@NotNull Link inputLink, @NotNull ItemStack itemStack, int tickInterval) {
        return this.chargeItem(inputLink.getPower(), itemStack, tickInterval);
    }

    private static int getFirstLineMatching(@NotNull List<String> lore, Predicate<? super String> matcher) {
        return IntStream.range(0, lore.size()).filter(i -> matcher.test(ChatColor.stripColor((String)((String)lore.get(i))))).findFirst().orElse(-1);
    }

    public static void updateLore(ItemStack itemStack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (!(slimefunItem instanceof QuapticChargeableItem)) {
            return;
        }
        QuapticChargeableItem chargeableItem = (QuapticChargeableItem)slimefunItem;
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        double currentCharge = PersistentDataAPI.getDouble((PersistentDataHolder)itemMeta, Keys.CHARGE, 0.0);
        Settings itemSettings = chargeableItem.settings;
        ArrayList<String> lore = itemMeta.getLore() == null ? new ArrayList() : itemMeta.getLore();
        int chargeBar = QuapticChargeableItem.getFirstLineMatching(lore, line -> line.contains("\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6\u00a6"));
        int chargeValues = QuapticChargeableItem.getFirstLineMatching(lore, line -> Stream.of("\u21e8 \u25c6 ", " / ", "QEU").allMatch(line::contains));
        if (chargeBar != -1) {
            lore.set(chargeBar, ChatColors.color(Lore.chargeBar((int)currentCharge, (int)itemSettings.getChargeCapacity())));
        }
        if (chargeValues != -1) {
            lore.set(chargeValues, ChatColors.color(Lore.chargeValues((int)currentCharge, (int)itemSettings.getChargeCapacity())));
        }
        itemMeta.setLore(lore);
        itemStack.setItemMeta(itemMeta);
    }

    public Settings getSettings() {
        return this.settings;
    }
}

