/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.infuser;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class InfusionPillar
extends ConnectedBlock
implements PowerAnimatedBlock {
    public static final Settings INFUSION_PILLAR_SETTINGS = Settings.builder().tier(Tier.BASIC).minPower(15.0).minFrequency(10.0).build();
    public static final SlimefunItemStack INFUSION_PILLAR = new SlimefunItemStack("QP_INFUSION_PILLAR", Material.BLUE_CONCRETE, "&6Infusion Pillar", Lore.create(INFUSION_PILLAR_SETTINGS, Lore.multiblockComponent()));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public InfusionPillar(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.3f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("pillar", new ModelCuboid().material(Material.BLUE_CONCRETE).facing(player.getFacing()).size(0.3f, 0.4f, 0.3f).location(0.0f, -0.3f, 0.0f)).add("prism", new ModelCuboid().material(Material.LIGHT_BLUE_STAINED_GLASS).brightness(3).facing(player.getFacing()).size(0.2f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", InfusionPillar.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_POWERED", false);
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (this.doBurnoutCheck(group, "input")) {
            return;
        }
        Optional<Link> link = InfusionPillar.getLink(location, "input");
        this.onPoweredAnimation(location, this.settings.isOperational(link));
        BlockStorageAPI.set(location, "QP_POWERED", this.settings.isOperational(link));
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "prism", powered);
    }
}

