/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.entangler;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.multiblocks.entangler.EntanglementContainer;
import org.metamechanists.quaptics.implementation.multiblocks.entangler.IndustrialEntanglementMagnet;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;

public class IndustrialEntanglementContainer
extends EntanglementContainer {
    public static final Settings INDUSTRIAL_ENTANGLEMENT_CONTAINER_SETTINGS = Settings.builder().tier(Tier.ADVANCED).timePerRecipe(15.0).build();
    public static final SlimefunItemStack INDUSTRIAL_ENTANGLEMENT_CONTAINER = new SlimefunItemStack("QP_INDUSTRIAL_ENTANGLEMENT_CONTAINER", Material.CYAN_CONCRETE, "&6Industrial Entanglement Container", Lore.create(INDUSTRIAL_ENTANGLEMENT_CONTAINER_SETTINGS, Lore.multiblock(), "&7\u25cf Entangles items", "&7\u25cf Can entangle up to 16 items at once", "&7\u25cf &eRight Click &7with an item to start the entanglement process"));
    private static final Map<Vector, ItemStack> MAGNETS = Map.ofEntries(Map.entry(new Vector(3, 0, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(-3, 0, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, 3, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, -3, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, 0, 3), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, 0, -3), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(2, 2, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(2, -2, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(-2, 2, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(-2, -2, 0), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(2, 0, 2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(2, 0, -2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(-2, 0, 2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(-2, 0, -2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, 2, 2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, 2, -2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, -2, 2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET), Map.entry(new Vector(0, -2, -2), IndustrialEntanglementMagnet.INDUSTRIAL_ENTANGLEMENT_MAGNET));

    public IndustrialEntanglementContainer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        if (this.multiblockInteract(location.getBlock(), player)) {
            return true;
        }
        this.itemHolderInteract(location, "item", player, 16);
        return true;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("frame1a", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, 0.8f, 0.0f).to(0.8f, 0.0f, 0.0f).thickness(0.1f).extraLength(0.1f)).add("frame1b", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, 0.8f, 0.0f).to(-0.8f, 0.0f, 0.0f).thickness(0.1f).extraLength(0.1f)).add("frame1c", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, 0.8f, 0.0f).to(0.0f, 0.0f, 0.8f).thickness(0.1f).extraLength(0.1f)).add("frame1d", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, 0.8f, 0.0f).to(0.0f, 0.0f, -0.8f).thickness(0.1f).extraLength(0.1f)).add("frame2a", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, -0.8f, 0.0f).to(0.8f, 0.0f, 0.0f).thickness(0.1f)).add("frame2b", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, -0.8f, 0.0f).to(-0.8f, 0.0f, 0.0f).thickness(0.1f)).add("frame2c", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, -0.8f, 0.0f).to(0.0f, 0.0f, 0.8f).thickness(0.1f)).add("frame2d", new ModelLine().material(Material.CYAN_CONCRETE).from(0.0f, -0.8f, 0.0f).to(0.0f, 0.0f, -0.8f).thickness(0.1f)).add("frame3a", new ModelLine().material(Material.CYAN_CONCRETE).from(0.8f, 0.0f, 0.0f).to(0.0f, 0.0f, 0.8f).thickness(0.1f)).add("frame3b", new ModelLine().material(Material.CYAN_CONCRETE).from(0.8f, 0.0f, 0.0f).to(0.0f, 0.0f, -0.8f).thickness(0.1f)).add("frame3c", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.8f, 0.0f, 0.0f).to(0.0f, 0.0f, 0.8f).thickness(0.1f)).add("frame3d", new ModelLine().material(Material.CYAN_CONCRETE).from(-0.8f, 0.0f, 0.0f).to(0.0f, 0.0f, -0.8f).thickness(0.1f)).add("item", new ModelItem().brightness(15).size(0.5f)).buildAtBlockCenter(location);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<ItemStack, ItemStack> recipe : super.getRecipes().entrySet()) {
            for (int i = 0; i < 16; ++i) {
                ItemStack input = recipe.getKey().clone();
                ItemStack output = recipe.getValue().clone();
                input.add(i);
                output.add(i);
                recipes.put(input, output);
            }
        }
        return recipes;
    }

    @Override
    public Map<Vector, ItemStack> getStructure() {
        return MAGNETS;
    }
}

