/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelLine;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.SlimefunIsDumbUtils;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class MultiblockClicker
extends ConnectedBlock
implements PowerAnimatedBlock {
    public static final Settings MULTIBLOCK_CLICKER_1_SETTINGS = Settings.builder().tier(Tier.BASIC).useInterval(20.0).minPower(20.0).minFrequency(2.0).build();
    public static final Settings MULTIBLOCK_CLICKER_2_SETTINGS = Settings.builder().tier(Tier.BASIC).useInterval(10.0).minPower(80.0).minFrequency(6.0).build();
    public static final Settings MULTIBLOCK_CLICKER_3_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).useInterval(4.0).minPower(200.0).minFrequency(50.0).build();
    public static final SlimefunItemStack MULTIBLOCK_CLICKER_1 = new SlimefunItemStack("QP_MULTIBLOCK_CLICKER_1", Material.DISPENSER, "&7Multiblock Clicker &fI", Lore.create(MULTIBLOCK_CLICKER_1_SETTINGS, "&7\u25cf Automatically clicks the attached multiblock", "&7\u25cf Place facing the block you'd usually click to use the multiblock", "&7\u25cf &eRight Click &7to enable/disable"));
    public static final SlimefunItemStack MULTIBLOCK_CLICKER_2 = new SlimefunItemStack("QP_MULTIBLOCK_CLICKER_2", Material.DISPENSER, "&7Multiblock Clicker &fII", Lore.create(MULTIBLOCK_CLICKER_2_SETTINGS, "&7\u25cf Automatically clicks the attached multiblock", "&7\u25cf Place facing the block you'd usually click to use the multiblock", "&7\u25cf &eRight Click &7to enable/disable"));
    public static final SlimefunItemStack MULTIBLOCK_CLICKER_3 = new SlimefunItemStack("QP_MULTIBLOCK_CLICKER_3", Material.DISPENSER, "&7Multiblock Clicker &fIII", Lore.create(MULTIBLOCK_CLICKER_3_SETTINGS, "&7\u25cf Automatically clicks the attached multiblock", "&7\u25cf Place facing the block you'd usually click to use the multiblock", "&7\u25cf &eRight Click &7to enable/disable"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public MultiblockClicker(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.35f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.CYAN_CONCRETE).brightness(3).size(0.3f)).add("attachment", new ModelLine().material(Material.WHITE_CONCRETE).to(player.getFacing().getDirection().toVector3f()).thickness(0.15f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", MultiblockClicker.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected void initBlockStorage(@NotNull Location location, @NotNull Player player) {
        BlockStorageAPI.set(location, "QP_TICKS_SINCE_LAST_UPDATE", 0);
        BlockStorageAPI.set(location, "QP_POWERED", false);
        BlockStorageAPI.set(location, "QP_FACING", player.getFacing());
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<UUID> uuid = BlockStorageAPI.getUuid(location, "QP_PLAYER");
        if (uuid.isEmpty()) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)uuid.get());
        boolean enabled = BlockStorageAPI.getBoolean(location, "QP_ENABLED");
        if (!enabled) {
            return;
        }
        Optional<Block> multiblockBlock = MultiblockClicker.getMultiblockBlock(location);
        if (multiblockBlock.isEmpty()) {
            this.setEnabled(location, false);
            return;
        }
        Optional<MultiBlockMachine> machine = SlimefunIsDumbUtils.getMultiblockMachine(multiblockBlock.get());
        if (machine.isEmpty()) {
            this.setEnabled(location, false);
            return;
        }
        Optional<Link> link = MultiblockClicker.getLink(location, "input");
        if (link.isEmpty() || !this.settings.isOperational(link)) {
            this.setEnabled(location, false);
            return;
        }
        int ticksSinceLastUpdate = BlockStorageAPI.getInt(location, "QP_TICKS_SINCE_LAST_UPDATE");
        ticksSinceLastUpdate += 2;
        if (owner == null || (double)ticksSinceLastUpdate < this.settings.getUseInterval()) {
            BlockStorageAPI.set(location, "QP_TICKS_SINCE_LAST_UPDATE", ticksSinceLastUpdate);
            return;
        }
        int usesInThisTick = (int)((double)ticksSinceLastUpdate / this.settings.getUseInterval());
        machine.get().onInteract(owner, multiblockBlock.get());
        ticksSinceLastUpdate = (int)((double)ticksSinceLastUpdate - (double)usesInThisTick * this.settings.getUseInterval());
        ticksSinceLastUpdate = (int)((double)ticksSinceLastUpdate % this.settings.getUseInterval());
        BlockStorageAPI.set(location, "QP_TICKS_SINCE_LAST_UPDATE", ticksSinceLastUpdate);
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        Optional<Block> multiblockBlock = MultiblockClicker.getMultiblockBlock(location);
        if (multiblockBlock.isEmpty()) {
            Language.sendLanguageMessage(player, "multiblock-clicker.not-connected-to-multiblock", new Object[0]);
            return true;
        }
        Optional<MultiBlockMachine> machine = SlimefunIsDumbUtils.getMultiblockMachine(multiblockBlock.get());
        if (machine.isEmpty()) {
            Language.sendLanguageMessage(player, "multiblock-clicker.not-connected-to-multiblock", new Object[0]);
            return true;
        }
        Optional<Link> link = MultiblockClicker.getLink(location, "input");
        if (link.isEmpty() || !this.settings.isOperational(link)) {
            Language.sendLanguageMessage(player, "multiblock-clicker.not-powered", new Object[0]);
            this.setEnabled(location, false);
            return true;
        }
        BlockStorageAPI.set(location, "QP_PLAYER", player.getUniqueId());
        boolean enabled = BlockStorageAPI.getBoolean(location, "QP_ENABLED");
        this.onPoweredAnimation(location, !enabled);
        this.setEnabled(location, !enabled);
        return true;
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        this.doBurnoutCheck(group, "input");
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        MultiblockClicker.getDisplay(location, "main").ifPresent(value -> value.setBrightness(new Display.Brightness(powered ? 15 : 3, 0)));
    }

    private void setEnabled(Location location, boolean enabled) {
        BlockStorageAPI.set(location, "QP_ENABLED", enabled);
        this.onPoweredAnimation(location, enabled);
    }

    private static Optional<Block> getMultiblockBlock(@NotNull Location location) {
        Optional<BlockFace> face = BlockStorageAPI.getBlockFace(location, "QP_FACING");
        return face.map(blockFace -> location.getBlock().getRelative(blockFace));
    }
}

