/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.consumers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelItem;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.ItemProcessor;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.items.groups.CraftingComponents;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class CrystalRefiner
extends ConnectedBlock
implements ItemHolderBlock,
PowerAnimatedBlock,
ItemProcessor {
    public static final Settings CRYSTAL_REFINER_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).timePerRecipe(3.0).minPower(300.0).minFrequency(30.0).build();
    public static final SlimefunItemStack CRYSTAL_REFINER = new SlimefunItemStack("QP_CRYSTAL_REFINER", Material.QUARTZ_BLOCK, "&bCrystal Refiner", Lore.create(CRYSTAL_REFINER_SETTINGS, "&7\u25cf Refines Phase Crystals", "&7\u25cf &eRight Click &7with an item to start refining"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());

    public CrystalRefiner(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.9f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("wall1", new ModelCuboid().material(Material.WHITE_CONCRETE).location(0.3f, -0.21f, -0.3f).size(0.2f, 0.6f, 1.1f).rotation(0.7853981633974483)).add("wall2", new ModelCuboid().material(Material.WHITE_CONCRETE).location(-0.3f, -0.21f, 0.3f).size(0.2f, 0.6f, 1.1f).rotation(0.7853981633974483)).add("wall3", new ModelCuboid().material(Material.WHITE_CONCRETE).location(0.3f, -0.21f, 0.3f).size(1.1f, 0.6f, 0.2f).rotation(0.7853981633974483)).add("wall4", new ModelCuboid().material(Material.WHITE_CONCRETE).location(-0.3f, -0.21f, -0.3f).size(1.1f, 0.6f, 0.2f).rotation(0.7853981633974483)).add("water", new ModelCuboid().material(Material.BLUE_CONCRETE).location(0.0f, -0.3f, 0.0f).size(1.0f, 0.4f, 1.0f).rotation(0.7853981633974483)).add("concrete", new ModelCuboid().material(this.settings.getTier().concreteMaterial).brightness(3).location(0.0f, -0.2f, 0.0f).size(0.3f).rotation(0.7853981633974483)).add("item", new ModelItem().facing(player.getFacing()).size(0.5f).location(0.0f, 0.1f, 0.0f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", CrystalRefiner.formatPointLocation(player, location, this.inputPointLocation)));
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@NotNull BlockPlaceEvent event) {
        super.onPlace(event);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.onBreakItemHolderBlock(location, "item");
    }

    @Override
    protected boolean onRightClick(@NotNull Location location, @NotNull Player player) {
        this.itemHolderInteract(location, "item", player);
        return true;
    }

    @Override
    public void onTick2(@NotNull ConnectionGroup group, @NotNull Location location) {
        if (!this.isProcessing(location)) {
            return;
        }
        if (!BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            this.cancelProcessing(location);
        }
        double secondsSinceCraftStarted = BlockStorageAPI.getDouble(location, "QP_TIME_SINCE_CRAFT_STARTED");
        this.tickProcessing(location, 2);
        CrystalRefiner.tickAnimation(location);
        if (secondsSinceCraftStarted >= this.settings.getTimePerRecipe()) {
            this.completeProcessing(location);
        }
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        this.doBurnoutCheck(group, "input");
        Optional<Link> inputLink = CrystalRefiner.getLink(location, "input");
        BlockStorageAPI.set(location, "QP_POWERED", this.settings.isOperational(inputLink));
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        if (!this.isValidRecipe(stack)) {
            Language.sendLanguageMessage(player, "crystal-refiner.invalid-item", new Object[0]);
            return false;
        }
        this.startProcessing(location);
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        this.cancelProcessing(location);
        return Optional.of(stack);
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        this.brightnessAnimation(location, "concrete", powered);
    }

    @Override
    public Map<ItemStack, ItemStack> getRecipes() {
        return Map.of(new ItemStack(Material.QUARTZ), CraftingComponents.PHASE_CRYSTAL_1, CraftingComponents.PHASE_CRYSTAL_1, CraftingComponents.PHASE_CRYSTAL_5, CraftingComponents.PHASE_CRYSTAL_5, CraftingComponents.PHASE_CRYSTAL_15, CraftingComponents.PHASE_CRYSTAL_15, CraftingComponents.PHASE_CRYSTAL_45, CraftingComponents.PHASE_CRYSTAL_45, CraftingComponents.PHASE_CRYSTAL_90, CraftingComponents.PHASE_CRYSTAL_90, CraftingComponents.PHASE_CRYSTAL_180);
    }

    private static void tickAnimation(@NotNull Location location) {
        location.getWorld().spawnParticle(Particle.BLOCK_DUST, location.toCenterLocation(), 4, 0.0, 0.0, 0.0, (Object)Material.QUARTZ_BLOCK.createBlockData());
    }
}

