/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.displaymodellib.sefilib.slimefun.blocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayInteractable;

public abstract class DisplayGroupBlock
extends SlimefunItem
implements DisplayInteractable {
    public static final String KEY_UUID = "display-uuid";
    private final Function<Location, DisplayGroup> displayGroupFunction;

    public DisplayGroupBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Function<Location, DisplayGroup> displayGroupFunction) {
        this(itemGroup, item, recipeType, recipe, null, displayGroupFunction);
    }

    public DisplayGroupBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, @Nullable ItemStack recipeOutput, Function<Location, DisplayGroup> displayGroupFunction) {
        super(itemGroup, item, recipeType, recipe, recipeOutput);
        this.displayGroupFunction = displayGroupFunction;
    }

    @OverridingMethodsMustInvokeSuper
    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent event) {
                Location location = event.getBlock().getLocation();
                DisplayGroup displayGroup = DisplayGroupBlock.this.displayGroupFunction.apply(location.clone().add(0.5, 0.0, 0.5));
                DisplayGroupBlock.this.setUUID(displayGroup, location);
                event.getBlock().setType(DisplayGroupBlock.this.getBaseMaterial());
                DisplayGroupBlock.this.whenPlaced(event);
            }
        }, new BlockBreakHandler(false, false){

            @ParametersAreNonnullByDefault
            public void onPlayerBreak(BlockBreakEvent e, ItemStack item, List<ItemStack> drops) {
                Location location = e.getBlock().getLocation();
                DisplayGroup displayGroup = DisplayGroupBlock.this.getDisplayGroup(location);
                if (displayGroup == null) {
                    return;
                }
                displayGroup.remove();
                e.getBlock().setType(Material.AIR);
            }
        }});
    }

    protected void whenPlaced(@Nonnull BlockPlaceEvent event) {
    }

    @ParametersAreNonnullByDefault
    protected void whenBroken(BlockBreakEvent event, ItemStack item, List<ItemStack> drops) {
    }

    @Nonnull
    protected abstract Material getBaseMaterial();

    private void setUUID(@Nonnull DisplayGroup displayGroup, @Nonnull Location location) {
        BlockStorage.addBlockInfo((Location)location, (String)KEY_UUID, (String)displayGroup.getParentUUID().toString());
    }

    @Nullable
    @OverridingMethodsMustInvokeSuper
    public UUID getUUID(@Nonnull Location location) {
        String uuid = BlockStorage.getLocationInfo((Location)location, (String)KEY_UUID);
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    @Nullable
    @OverridingMethodsMustInvokeSuper
    public DisplayGroup getDisplayGroup(@Nonnull Location location) {
        UUID uuid = this.getUUID(location);
        if (uuid == null) {
            return null;
        }
        return DisplayGroup.fromUUID(uuid);
    }
}

