/*
 * Decompiled with CFR 0.152.
 */
package dev.sefiraat.sefilib.localization;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private static final Pattern YAML_ENTRY = Pattern.compile("[a-z0-9_-]+:.*");
    private final JavaPlugin javaPlugin;
    private final FileConfiguration defaultLanguage;
    private final FileConfiguration selectedLanguage;

    @ParametersAreNonnullByDefault
    public LanguageManager(JavaPlugin javaPlugin, String langDirectory, String chosenLang, String defaultLang) {
        this.javaPlugin = javaPlugin;
        this.defaultLanguage = this.load(javaPlugin, langDirectory, defaultLang);
        this.selectedLanguage = this.load(javaPlugin, langDirectory, chosenLang);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private FileConfiguration load(JavaPlugin plugin, String directory, String fileName) {
        YamlConfiguration yamlConfiguration;
        InputStream stream = plugin.getResource(directory + "/" + fileName);
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)("Unable to find language file " + fileName));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            String content = reader.lines().collect(Collectors.joining("\n"));
            YamlConfiguration config = new YamlConfiguration();
            if (YAML_ENTRY.matcher(content).find()) {
                config.loadFromString(content);
            }
            yamlConfiguration = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidConfigurationException e) {
                this.javaPlugin.getLogger().severe("Unable to find/load language file " + fileName);
                this.javaPlugin.getLogger().severe(e.getMessage());
                return new YamlConfiguration();
            }
        }
        reader.close();
        return yamlConfiguration;
    }

    @Nonnull
    public String getString(@Nonnull String path) {
        return this.getString(path, new Object[0]);
    }

    @Nonnull
    public String getString(@Nonnull String path, Object ... replacements) {
        String string = this.selectedLanguage.getString(path);
        if (string == null) {
            string = this.defaultLanguage.getString(path);
        }
        if (string != null) {
            for (int i = 0; i < replacements.length; ++i) {
                string = string.replace("{" + i + "}", replacements[i].toString());
            }
        }
        return Objects.requireNonNullElse(string, "Localisation error");
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path) {
        return this.getStringList(path, new Object[0]);
    }

    @Nonnull
    public List<String> getStringList(@Nonnull String path, Object ... replacements) {
        List<String> strings = this.selectedLanguage.getStringList(path);
        if (strings.isEmpty()) {
            strings = this.defaultLanguage.getStringList(path);
        }
        strings = strings.isEmpty() ? List.of("Localisation error") : strings.stream().map(string -> {
            for (int i = 0; i < replacements.length; ++i) {
                string = string.replace("{" + i + "}", replacements[i].toString());
            }
            return string;
        }).toList();
        return strings;
    }

    @Nonnull
    public String[] getStringArray(@Nonnull String path) {
        return this.getStringArray(path, new Object[0]);
    }

    @Nonnull
    public String[] getStringArray(@Nonnull String path, Object ... replacements) {
        return this.getStringList(path, replacements).toArray(new String[0]);
    }

    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    public FileConfiguration getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public FileConfiguration getSelectedLanguage() {
        return this.selectedLanguage;
    }
}

