/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.metalib.sefilib.itemstacks;

import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import javax.annotation.Nonnull;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public final class ItemStackGenerators {
    private ItemStackGenerators() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    public static ItemStack createPotion(@Nonnull Color color) {
        ItemStack itemStack = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionData(new PotionData(PotionType.WATER));
        potionMeta.setColor(color);
        potionMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        itemStack.setItemMeta((ItemMeta)potionMeta);
        return itemStack;
    }

    @Nonnull
    @SafeVarargs
    public static ItemStack createEnchantedItemStack(@Nonnull Material material, Pair<Enchantment, Integer> ... enchantments) {
        return ItemStackGenerators.createEnchantedItemStack(material, false, enchantments);
    }

    @Nonnull
    @SafeVarargs
    public static ItemStack createEnchantedItemStack(@Nonnull Material material, boolean hide, Pair<Enchantment, Integer> ... enchantments) {
        ItemStack itemStack = new ItemStack(material);
        ItemMeta itemMeta = itemStack.getItemMeta();
        for (Pair<Enchantment, Integer> pair : enchantments) {
            itemMeta.addEnchant((Enchantment)pair.getFirstValue(), ((Integer)pair.getSecondValue()).intValue(), true);
        }
        if (hide) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }
}

