/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.multiblocks.beacons.controllers;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.displaymodellib.builders.InteractionBuilder;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.ComplexMultiblock;
import org.metamechanists.quaptics.implementation.attachments.ItemHolderBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.BeaconModule;
import org.metamechanists.quaptics.implementation.multiblocks.beacons.modules.PlayerModule;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.Language;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;

public abstract class BeaconController
extends ConnectedBlock
implements ItemHolderBlock,
ComplexMultiblock,
PowerAnimatedBlock {
    private static final float MODULE_BUTTON_WIDTH = 0.2f;
    private static final float MODULE_BUTTON_HEIGHT = 0.42f;
    private static final Vector3f MODULE_BUTTON_OFFSET = new Vector3f(0.0f, 0.13f, 0.0f);

    protected BeaconController(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.0f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        DisplayGroup displayGroup = new ModelBuilder().buildAtBlockCenter(location);
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroup.getParentUUID());
        traverser.set("QP_PLAYER_RECEIVERS", new ArrayList<UUID>());
        return displayGroup;
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of();
    }

    @NotNull
    public static ItemStack emptyItemStack() {
        ItemStack stack = new ItemStack(Material.BLACK_BANNER);
        BannerMeta meta = (BannerMeta)stack.getItemMeta();
        meta.addPattern(new Pattern(DyeColor.RED, PatternType.CIRCLE_MIDDLE));
        stack.setItemMeta((ItemMeta)meta);
        return stack;
    }

    @Override
    @NotNull
    public ItemStack getEmptyItemStack() {
        return BeaconController.emptyItemStack();
    }

    @Override
    public boolean isEmptyItemStack(@NotNull ItemStack itemStack) {
        return itemStack.equals((Object)this.getEmptyItemStack());
    }

    @Override
    protected boolean isTicker() {
        return true;
    }

    @Override
    public void onTick22(@NotNull ConnectionGroup group, @NotNull Location location) {
        boolean isStructureValid = this.isStructureValid(location.getBlock());
        BlockStorageAPI.set(location, "QP_MULTIBLOCK_INTACT", isStructureValid);
        if (!isStructureValid) {
            this.onPoweredAnimation(location, false);
            return;
        }
        Location powerSupplyLocation = location.clone().add(this.getPowerSupplyLocation());
        double power = BlockStorageAPI.getDouble(powerSupplyLocation, "QP_POWER");
        double frequency = BlockStorageAPI.getDouble(powerSupplyLocation, "QP_FREQUENCY");
        boolean powered = power >= this.settings.getMinPower() && frequency > this.settings.getMinFrequency();
        BlockStorageAPI.set(location, "QP_POWERED", powered);
        this.onPoweredAnimation(location, powered);
        if (!powered) {
            return;
        }
        Set<BeaconModule> modules = this.getModules(location);
        this.tickPlayerModules(location, modules);
    }

    @Override
    public void onTick102(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<DisplayGroup> displayGroup = BeaconController.getDisplayGroup(location);
        if (displayGroup.isEmpty()) {
            return;
        }
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroup.get().getParentUUID());
        traverser.set("QP_PLAYER_RECEIVERS", new ArrayList<UUID>());
        if (!BlockStorageAPI.getBoolean(location, "QP_MULTIBLOCK_INTACT") || !BlockStorageAPI.getBoolean(location, "QP_POWERED")) {
            return;
        }
        traverser.set("QP_PLAYER_RECEIVERS", this.getNearbyPlayerUuids(location));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@NotNull Location location) {
        super.onBreak(location);
        this.getModuleDisplayNames().forEach(name -> this.breakModuleSlot(location, (String)name));
        BeaconController.getDisplayGroup(location).ifPresent(BeaconController::breakInteractions);
    }

    @Override
    public boolean onInsert(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack, @NotNull Player player) {
        SlimefunItem moduleItem = SlimefunItem.getByItem((ItemStack)stack);
        if (!(moduleItem instanceof BeaconModule)) {
            Language.sendLanguageMessage(player, "beacon.not-module", new Object[0]);
            return false;
        }
        BeaconModule beaconModule = (BeaconModule)moduleItem;
        if (this.getModules(location).contains((Object)beaconModule)) {
            Language.sendLanguageMessage(player, "beacon.duplicate-module", new Object[0]);
            return false;
        }
        if (!Tier.greaterOrEqual(beaconModule.getSettings().getTier(), this.settings.getTier())) {
            Language.sendLanguageMessage(player, "beacon.incorrect-tier", this.settings.getTier().name);
            return false;
        }
        return true;
    }

    @Override
    public Optional<ItemStack> onRemove(@NotNull Location location, @NotNull String name, @NotNull ItemStack stack) {
        QuapticChargeableItem.updateLore(stack);
        return Optional.of(stack);
    }

    private List<UUID> getNearbyPlayerUuids(@NotNull Location location) {
        BoundingBox boundingBox = new BoundingBox(location.x() + (double)(this.settings.getRange() * 2), location.y() + 1000.0, location.z() + (double)(this.settings.getRange() * 2), location.x() - (double)(this.settings.getRange() * 2), location.y() - 1000.0, location.z() - (double)(this.settings.getRange() * 2));
        return Bukkit.getOnlinePlayers().stream().filter(player -> boundingBox.contains(player.getLocation().toVector())).map(Entity::getUniqueId).toList();
    }

    @NotNull
    private static List<Player> getStoredPlayers(@NotNull Location location) {
        Optional<DisplayGroup> displayGroup = BeaconController.getDisplayGroup(location);
        if (displayGroup.isEmpty()) {
            return new ArrayList<Player>();
        }
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroup.get().getParentUUID());
        List<UUID> uuids = traverser.getUuidList("QP_PLAYER_RECEIVERS");
        if (uuids == null) {
            return new ArrayList<Player>();
        }
        return uuids.stream().map(Bukkit::getPlayer).toList();
    }

    @NotNull
    protected static InteractionId createButton(ConnectionGroupId groupId, @NotNull Location location, Vector3f relativeLocation, String slot) {
        Interaction interaction = new InteractionBuilder().width(0.2f).height(0.42f).build(location.clone().toCenterLocation().add(Vector.fromJOML((Vector3f)MODULE_BUTTON_OFFSET)).add(Vector.fromJOML((Vector3f)relativeLocation)));
        PersistentDataTraverser traverser = new PersistentDataTraverser(interaction.getUniqueId());
        traverser.set("groupId", groupId);
        traverser.set("slot", slot);
        return new InteractionId(interaction.getUniqueId());
    }

    private void breakModuleSlot(@NotNull Location location, String name) {
        Optional<ItemStack> stack = ItemHolderBlock.getStack(location, name);
        if (stack.isEmpty() || stack.get().equals((Object)this.getEmptyItemStack())) {
            return;
        }
        this.onBreakItemHolderBlock(location, name);
    }

    private static void breakInteractions(@NotNull DisplayGroup displayGroup) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(displayGroup.getParentUUID());
        List<InteractionId> interactionIds = traverser.getCustomIdList("QP_INTERACTION_ID_LIST");
        if (interactionIds == null) {
            return;
        }
        interactionIds.stream().map(InteractionId::get).filter(Optional::isPresent).map(Optional::get).forEach(Entity::remove);
    }

    public void interact(Player player, @NotNull ConnectionGroup group, String slot) {
        Optional<Location> location = group.getLocation();
        if (location.isEmpty()) {
            return;
        }
        this.itemHolderInteract(location.get(), slot, player);
    }

    private static Optional<BeaconModule> getModule(ItemStack itemStack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (slimefunItem instanceof BeaconModule) {
            BeaconModule beaconModule = (BeaconModule)slimefunItem;
            return Optional.of(beaconModule);
        }
        return Optional.empty();
    }

    private Set<BeaconModule> getModules(@NotNull Location location) {
        return this.getModuleDisplayNames().stream().map(name -> ItemHolderBlock.getStack(location, name)).filter(Optional::isPresent).map(Optional::get).map(BeaconController::getModule).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private void tickPlayerModules(@NotNull Location location, @NotNull Set<BeaconModule> modules) {
        Set<PlayerModule> playerModules = modules.stream().filter(module -> module instanceof PlayerModule).map(PlayerModule.class::cast).collect(Collectors.toSet());
        if (!playerModules.isEmpty()) {
            playerModules.forEach(module -> module.apply(this, location, BeaconController.getStoredPlayers(location)));
        }
    }

    public abstract Vector getPowerSupplyLocation();

    protected abstract List<String> getModuleDisplayNames();
}

