/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.implementation.blocks.upgraders;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.connections.Link;
import org.metamechanists.quaptics.displaymodellib.models.ModelBuilder;
import org.metamechanists.quaptics.displaymodellib.models.components.ModelCuboid;
import org.metamechanists.quaptics.displaymodellib.sefilib.entity.display.DisplayGroup;
import org.metamechanists.quaptics.implementation.Settings;
import org.metamechanists.quaptics.implementation.attachments.PowerAnimatedBlock;
import org.metamechanists.quaptics.implementation.attachments.PowerLossBlock;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.items.Tier;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;

public class Scatterer
extends ConnectedBlock
implements PowerAnimatedBlock,
PowerLossBlock {
    public static final Settings SCATTERER_1_SETTINGS = Settings.builder().tier(Tier.BASIC).maxPowerHidden(true).minPower(40.0).powerLoss(0.06).minFrequency(5.0).maxFrequency(10.0).frequencyMultiplier(1.4).comparatorVisual("compare").build();
    public static final Settings SCATTERER_2_SETTINGS = Settings.builder().tier(Tier.INTERMEDIATE).maxPowerHidden(true).minPower(360.0).powerLoss(0.03).minFrequency(40.0).maxFrequency(200.0).frequencyMultiplier(1.8).comparatorVisual("compare").build();
    public static final Settings SCATTERER_3_SETTINGS = Settings.builder().tier(Tier.ADVANCED).maxPowerHidden(true).minPower(1800.0).powerLoss(0.03).minFrequency(40000.0).maxFrequency(160000.0).frequencyMultiplier(1.5).comparatorVisual("compare").build();
    public static final SlimefunItemStack SCATTERER_1 = new SlimefunItemStack("QP_SCATTERER_1", Material.CYAN_STAINED_GLASS, "&cScatterer &4I", Lore.create(SCATTERER_1_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    public static final SlimefunItemStack SCATTERER_2 = new SlimefunItemStack("QP_SCATTERER_2", Material.CYAN_STAINED_GLASS, "&cScatterer &4II", Lore.create(SCATTERER_2_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    public static final SlimefunItemStack SCATTERER_3 = new SlimefunItemStack("QP_SCATTERER_3", Material.CYAN_STAINED_GLASS, "&cScatterer &4III", Lore.create(SCATTERER_3_SETTINGS, "&7\u25cf Increases the frequency of a quaptic ray"));
    private final Vector inputPointLocation = new Vector(0.0f, 0.0f, -this.getConnectionRadius());
    private final Vector outputPointLocation = new Vector(0.0f, 0.0f, this.getConnectionRadius());

    public Scatterer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, Settings settings) {
        super(itemGroup, item, recipeType, recipe, settings);
    }

    @Override
    public float getConnectionRadius() {
        return 0.4f;
    }

    @Override
    protected DisplayGroup initModel(@NotNull Location location, @NotNull Player player) {
        return new ModelBuilder().add("main", new ModelCuboid().material(Material.CYAN_STAINED_GLASS).facing(player.getFacing()).size(0.4f).rotation(0.7853981633974483)).add("prism", new ModelCuboid().material(this.settings.getTier().concreteMaterial).facing(player.getFacing()).rotation(0.7853981633974483).size(0.3f, 0.1f, 0.3f)).add("comparator", new ModelCuboid().block(this.createComparatorBlockData(false)).facing(player.getFacing()).location(0.0f, 0.1f, 0.0f).size(0.2f, 0.1f, 0.2f)).buildAtBlockCenter(location);
    }

    @Override
    protected List<ConnectionPoint> initConnectionPoints(ConnectionGroupId groupId, Player player, Location location) {
        return List.of(new ConnectionPoint(ConnectionPointType.INPUT, groupId, "input", Scatterer.formatPointLocation(player, location, this.inputPointLocation)), new ConnectionPoint(ConnectionPointType.OUTPUT, groupId, "output", Scatterer.formatPointLocation(player, location, this.outputPointLocation)));
    }

    @Override
    public void onInputLinkUpdated(@NotNull ConnectionGroup group, @NotNull Location location) {
        Optional<Link> inputLink = Scatterer.getLink(location, "input");
        Optional<Link> outputLink = Scatterer.getLink(location, "output");
        this.onPoweredAnimation(location, this.settings.isOperational(inputLink));
        if (outputLink.isEmpty()) {
            return;
        }
        if (inputLink.isEmpty() || !this.settings.isOperational(inputLink.get())) {
            outputLink.get().disable();
            return;
        }
        outputLink.get().setPowerFrequencyPhase(PowerLossBlock.calculatePowerLoss(this.settings, inputLink.get()), Scatterer.calculateFrequency(this.settings, inputLink.get().getFrequency()), inputLink.get().getPhase());
    }

    @Override
    public void onPoweredAnimation(@NotNull Location location, boolean powered) {
        Optional<BlockDisplay> blockDisplay = Scatterer.getBlockDisplay(location, "comparator");
        blockDisplay.ifPresent(display -> display.setBlock(this.createComparatorBlockData(powered)));
    }

    private static double calculateFrequency(@NotNull Settings settings, double frequency) {
        return frequency * settings.getFrequencyMultiplier();
    }

    @NotNull
    private BlockData createComparatorBlockData(boolean powered) {
        return Material.COMPARATOR.createBlockData("[mode=" + this.settings.getComparatorVisual() + ",powered=" + Objects.toString(powered) + "]");
    }
}

