/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.connections;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionPoint;
import org.metamechanists.quaptics.implementation.base.ConnectedBlock;
import org.metamechanists.quaptics.items.Groups;
import org.metamechanists.quaptics.panels.info.implementation.PointInfoPanel;
import org.metamechanists.quaptics.storage.PersistentDataTraverser;
import org.metamechanists.quaptics.storage.QuapticStorage;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;

public class ConnectionGroup {
    private final ConnectionGroupId id;
    private final String blockId;
    private final Map<String, ConnectionPointId> points;
    private final boolean isTicker;

    public ConnectionGroup(ConnectionGroupId id, @NotNull ConnectedBlock block, @NotNull Iterable<ConnectionPoint> pointsIn, boolean isTicker) {
        this.id = id;
        this.blockId = block.getId();
        this.points = new HashMap<String, ConnectionPointId>();
        this.isTicker = isTicker;
        pointsIn.forEach(point -> this.points.put(point.getName(), point.getId()));
        this.saveData();
    }

    public ConnectionGroup(ConnectionGroupId id) {
        PersistentDataTraverser traverser = new PersistentDataTraverser(id);
        this.id = id;
        this.blockId = traverser.getString("blockId");
        this.points = traverser.getPointIdMap("points");
        this.isTicker = traverser.getBoolean("isTicker");
    }

    private void saveData() {
        PersistentDataTraverser traverser = new PersistentDataTraverser(this.id);
        traverser.set("blockId", this.blockId);
        traverser.set("points", this.points);
        traverser.set("isTicker", this.isTicker);
    }

    public Optional<ConnectionPoint> getPoint(String name) {
        return this.points.get(name).get();
    }

    public ConnectionPoint addPoint(@NotNull ConnectionPoint point) {
        this.points.put(point.getName(), point.getId());
        this.saveData();
        return point;
    }

    public Optional<ConnectionPoint> removePoint(@NotNull ConnectionPoint point) {
        return this.removePoint(point.getName());
    }

    public Optional<ConnectionPoint> removePoint(@NotNull String name) {
        ConnectionPointId point = this.points.remove(name);
        this.saveData();
        return point == null ? Optional.empty() : point.get();
    }

    public ConnectedBlock getBlock() {
        return Groups.getBlocks().get(this.blockId);
    }

    public Optional<Location> getLocation() {
        return Optional.ofNullable(Bukkit.getEntity((UUID)this.id.getUUID())).map(Entity::getLocation);
    }

    public List<ConnectionPoint> getPointList() {
        return this.points.values().stream().map(ConnectionPointId::get).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public List<PointInfoPanel> getPointPanels() {
        return this.getPointList().stream().map(ConnectionPoint::getPointPanel).filter(Optional::isPresent).map(Optional::get).toList();
    }

    public void tick2() {
        Optional<Location> locationOptional = this.getLocation();
        locationOptional.ifPresent(location -> this.getBlock().onTick2(this, (Location)location));
    }

    public void tick6() {
        Optional<Location> locationOptional = this.getLocation();
        locationOptional.ifPresent(location -> this.getBlock().onTick6(this, (Location)location));
    }

    public void tick22() {
        Optional<Location> locationOptional = this.getLocation();
        locationOptional.ifPresent(location -> this.getBlock().onTick22(this, (Location)location));
    }

    public void tick102() {
        Optional<Location> locationOptional = this.getLocation();
        locationOptional.ifPresent(location -> this.getBlock().onTick102(this, (Location)location));
    }

    public void updatePanels() {
        this.getPointList().forEach(ConnectionPoint::updatePanel);
    }

    public void remove() {
        this.getPointList().forEach(ConnectionPoint::remove);
        QuapticStorage.removeGroup(this.id);
    }

    public ConnectionGroupId getId() {
        return this.id;
    }

    public Map<String, ConnectionPointId> getPoints() {
        return this.points;
    }
}

