/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandHelp;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.HelpCommand;
import co.aikar.commands.annotation.Private;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.annotation.Syntax;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.implementation.tools.QuapticChargeableItem;
import org.metamechanists.quaptics.utils.Language;

@CommandAlias(value="qp|quaptics")
public class QuapticsCommand
extends BaseCommand {
    @HelpCommand
    @Syntax(value="")
    @Private
    public static void helpCommand(CommandSender sender, @NotNull CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="charge")
    @Syntax(value="<amount> - &7Charges the item held in your hand")
    @CommandPermission(value="quaptics.command.charge")
    public static void charge(Player player, String @NotNull [] args) {
        if (args.length < 1) {
            Language.sendLanguageMessage(player, "command.invalid-argument-count", new Object[0]);
            return;
        }
        ItemStack itemStack = player.getInventory().getItem(EquipmentSlot.HAND);
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (!(slimefunItem instanceof QuapticChargeableItem)) {
            Language.sendLanguageMessage(player, "command.charge.cannot-be-charged", new Object[0]);
            return;
        }
        QuapticChargeableItem chargeableItem = (QuapticChargeableItem)slimefunItem;
        if (!args[0].matches("-?\\d+")) {
            Language.sendLanguageMessage(player, "command.charge.not-an-integer", new Object[0]);
            return;
        }
        chargeableItem.chargeItem(Integer.valueOf(args[0]).doubleValue(), itemStack, 20);
        QuapticChargeableItem.updateLore(itemStack);
    }
}

