/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CommandReplacements {
    private final CommandManager manager;
    private final Map<String, Map.Entry<Pattern, String>> replacements = new LinkedHashMap<String, Map.Entry<Pattern, String>>();

    CommandReplacements(CommandManager manager) {
        this.manager = manager;
        this.addReplacement0("truthy", "true|false|yes|no|1|0|on|off|t|f");
    }

    public void addReplacements(String ... replacements) {
        if (replacements.length == 0 || replacements.length % 2 != 0) {
            throw new IllegalArgumentException("Must pass a number of arguments divisible by 2.");
        }
        for (int i = 0; i < replacements.length; i += 2) {
            this.addReplacement(replacements[i], replacements[i + 1]);
        }
    }

    public String addReplacement(String key, String val) {
        return this.addReplacement0(key, val);
    }

    @Nullable
    private String addReplacement0(String key, String val) {
        Pattern pattern;
        AbstractMap.SimpleImmutableEntry<Pattern, String> entry;
        Map.Entry replaced = this.replacements.put(key = ACFPatterns.PERCENTAGE.matcher(key.toLowerCase(Locale.ENGLISH)).replaceAll(""), entry = new AbstractMap.SimpleImmutableEntry<Pattern, String>(pattern = Pattern.compile("%\\{" + Pattern.quote(key) + "}|%" + Pattern.quote(key) + "\\b", 2), val));
        if (replaced != null) {
            return (String)replaced.getValue();
        }
        return null;
    }

    public String replace(String text) {
        if (text == null) {
            return null;
        }
        for (Map.Entry<Pattern, String> entry : this.replacements.values()) {
            text = entry.getKey().matcher(text).replaceAll(entry.getValue());
        }
        Matcher matcher = ACFPatterns.REPLACEMENT_PATTERN.matcher(text);
        while (matcher.find()) {
            this.manager.log(LogLevel.ERROR, "Found unregistered replacement: " + matcher.group());
        }
        return text;
    }
}

