/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.storage;

import io.github.bakedlibs.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.metamechanists.quaptics.Quaptics;
import org.metamechanists.quaptics.connections.ConnectionPointType;
import org.metamechanists.quaptics.utils.id.CustomId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.ConfigPanelId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.ConnectionPointId;
import org.metamechanists.quaptics.utils.id.complex.DirectBeamId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelAttributeId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;
import org.metamechanists.quaptics.utils.id.complex.LinkId;
import org.metamechanists.quaptics.utils.id.simple.BlockDisplayId;
import org.metamechanists.quaptics.utils.id.simple.DisplayGroupId;
import org.metamechanists.quaptics.utils.id.simple.InteractionId;
import org.metamechanists.quaptics.utils.id.simple.ItemDisplayId;
import org.metamechanists.quaptics.utils.id.simple.TextDisplayId;

public class PersistentDataTraverser {
    private final PersistentDataHolder persistentDataHolder;
    private static final Map<String, NamespacedKey> keys = new ConcurrentHashMap<String, NamespacedKey>();
    private static final NamespacedKey slimefunKey = Slimefun.getItemDataService().getKey();

    public PersistentDataTraverser(@NotNull CustomId id) {
        this.persistentDataHolder = Bukkit.getEntity((UUID)id.getUUID());
    }

    public PersistentDataTraverser(@NotNull UUID id) {
        this.persistentDataHolder = Bukkit.getEntity((UUID)id);
    }

    public PersistentDataTraverser(@NotNull PersistentDataHolder entity) {
        this.persistentDataHolder = entity;
    }

    public PersistentDataTraverser(@NotNull ItemStack stack) {
        this.persistentDataHolder = stack.getItemMeta();
    }

    public void save(@NotNull ItemStack stack) {
        stack.setItemMeta((ItemMeta)this.persistentDataHolder);
    }

    @NotNull
    private static NamespacedKey getKey(@NotNull String key) {
        return keys.computeIfAbsent(key, k -> new NamespacedKey((Plugin)Quaptics.getInstance(), key));
    }

    public void remove(@NotNull String key) {
        PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
    }

    public void removeIf(@NotNull Predicate<String> predicate) {
        keys.keySet().stream().filter(predicate).forEach(this::remove);
    }

    public void set(@NotNull String key, int value) {
        PersistentDataAPI.setInt(this.persistentDataHolder, PersistentDataTraverser.getKey(key), value);
    }

    public void set(@NotNull String key, double value) {
        PersistentDataAPI.setDouble(this.persistentDataHolder, PersistentDataTraverser.getKey(key), value);
    }

    public void set(@NotNull String key, boolean value) {
        PersistentDataAPI.setBoolean(this.persistentDataHolder, PersistentDataTraverser.getKey(key), value);
    }

    public void set(@NotNull String key, @Nullable String value) {
        if (value == null) {
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
            return;
        }
        PersistentDataAPI.setString(this.persistentDataHolder, PersistentDataTraverser.getKey(key), value);
    }

    public void set(@NotNull String key, @Nullable Vector value) {
        if (value == null) {
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "x"));
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "y"));
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "z"));
            return;
        }
        this.set(key + "x", value.getX());
        this.set(key + "y", value.getY());
        this.set(key + "z", value.getZ());
    }

    public void set(@NotNull String key, @Nullable Vector3f value) {
        if (value == null) {
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "x"));
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "y"));
            PersistentDataAPI.remove(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "z"));
            return;
        }
        this.set(key + "x", value.x);
        this.set(key + "y", value.y);
        this.set(key + "z", value.z);
    }

    public void set(@NotNull String key, @Nullable CustomId value) {
        this.set(key, value == null ? null : value.toString());
    }

    public void set(@NotNull String key, @NotNull ConnectionPointType value) {
        this.set(key, value.toString());
    }

    public void set(@NotNull String key, @NotNull Map<String, ? extends CustomId> value) {
        this.set(key + "length", value.size());
        int i = 0;
        for (Map.Entry<String, ? extends CustomId> pair : value.entrySet()) {
            this.set(key + i + "key", pair.getKey());
            this.set(key + i + "value", pair.getValue().toString());
            ++i;
        }
    }

    public void set(@NotNull String key, @NotNull List<UUID> value) {
        this.set(key + "length", value.size());
        int i = 0;
        for (UUID uuid : value) {
            this.set(key + i, uuid.toString());
            ++i;
        }
    }

    public void setCustomIdList(@NotNull String key, @NotNull List<? extends CustomId> value) {
        this.set(key + "length", value.size());
        int i = 0;
        for (CustomId customId : value) {
            this.set(key + i, customId.toString());
            ++i;
        }
    }

    public int getInt(@NotNull String key) {
        return PersistentDataAPI.getInt(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
    }

    public double getDouble(@NotNull String key) {
        return PersistentDataAPI.getDouble(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
    }

    public boolean getBoolean(@NotNull String key) {
        return PersistentDataAPI.getBoolean(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
    }

    @Nullable
    public String getString(@NotNull String key) {
        return PersistentDataAPI.getString(this.persistentDataHolder, PersistentDataTraverser.getKey(key));
    }

    @Nullable
    public String getSlimefunId() {
        return PersistentDataAPI.getString(this.persistentDataHolder, slimefunKey);
    }

    @Nullable
    public Vector getVector(@NotNull String key) {
        return new Vector(PersistentDataAPI.getDouble(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "x")), PersistentDataAPI.getDouble(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "y")), PersistentDataAPI.getDouble(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "z")));
    }

    @Nullable
    public Vector3f getVector3f(@NotNull String key) {
        return new Vector3f(PersistentDataAPI.getFloat(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "x")), PersistentDataAPI.getFloat(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "y")), PersistentDataAPI.getFloat(this.persistentDataHolder, PersistentDataTraverser.getKey(key + "z")));
    }

    @Nullable
    public ConnectionPointType getConnectionPointType(@NotNull String key) {
        return ConnectionPointType.valueOf(this.getString(key));
    }

    @Nullable
    public BlockDisplayId getBlockDisplayId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new BlockDisplayId(uuid);
    }

    @Nullable
    public ItemDisplayId getItemDisplayId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new ItemDisplayId(uuid);
    }

    @Nullable
    public ConnectionGroupId getConnectionGroupId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new ConnectionGroupId(uuid);
    }

    @Nullable
    public ConnectionPointId getConnectionPointId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new ConnectionPointId(uuid);
    }

    @Nullable
    public DisplayGroupId getDisplayGroupId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new DisplayGroupId(uuid);
    }

    @Nullable
    public InteractionId getInteractionId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new InteractionId(uuid);
    }

    @Nullable
    public LinkId getLinkId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new LinkId(uuid);
    }

    @Nullable
    public InfoPanelAttributeId getInfoPanelAttributeId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new InfoPanelAttributeId(uuid);
    }

    @Nullable
    public ConfigPanelAttributeId getConfigPanelAttributeId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new ConfigPanelAttributeId(uuid);
    }

    @Nullable
    public InfoPanelId getInfoPanelId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new InfoPanelId(uuid);
    }

    @Nullable
    public ConfigPanelId getConfigPanelId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new ConfigPanelId(uuid);
    }

    @Nullable
    public TextDisplayId getTextDisplayId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new TextDisplayId(uuid);
    }

    @Nullable
    public DirectBeamId getBeamId(@NotNull String key) {
        String uuid = this.getString(key);
        return uuid == null ? null : new DirectBeamId(uuid);
    }

    @NotNull
    public Map<String, ConnectionPointId> getPointIdMap(@NotNull String key) {
        int size = this.getInt(key + "length");
        HashMap<String, ConnectionPointId> list = new HashMap<String, ConnectionPointId>();
        IntStream.range(0, size).forEach(i -> {
            String mapKey = this.getString(key + i + "key");
            ConnectionPointId mapValue = this.getConnectionPointId(key + i + "value");
            list.put(mapKey, mapValue);
        });
        return list;
    }

    @NotNull
    public Map<String, InfoPanelAttributeId> getInfoPanelAttributeIdMap(@NotNull String key) {
        int size = this.getInt(key + "length");
        LinkedHashMap<String, InfoPanelAttributeId> list = new LinkedHashMap<String, InfoPanelAttributeId>();
        IntStream.range(0, size).forEach(i -> {
            String mapKey = this.getString(key + i + "key");
            InfoPanelAttributeId mapValue = this.getInfoPanelAttributeId(key + i + "value");
            list.put(mapKey, mapValue);
        });
        return list;
    }

    @NotNull
    public Map<String, ConfigPanelAttributeId> getConfigPanelAttributeIdMap(@NotNull String key) {
        int size = this.getInt(key + "length");
        LinkedHashMap<String, ConfigPanelAttributeId> list = new LinkedHashMap<String, ConfigPanelAttributeId>();
        IntStream.range(0, size).forEach(i -> {
            String mapKey = this.getString(key + i + "key");
            ConfigPanelAttributeId mapValue = this.getConfigPanelAttributeId(key + i + "value");
            list.put(mapKey, mapValue);
        });
        return list;
    }

    @Nullable
    public List<UUID> getUuidList(@NotNull String key) {
        int size = this.getInt(key + "length");
        if (size == 0) {
            return null;
        }
        return IntStream.range(0, size).mapToObj(i -> this.getString(key + i)).filter(Objects::nonNull).map(UUID::fromString).collect(Collectors.toList());
    }

    @Nullable
    public List<InteractionId> getCustomIdList(@NotNull String key) {
        int size = this.getInt(key + "length");
        if (size == 0) {
            return null;
        }
        return IntStream.range(0, size).mapToObj(i -> this.getString(key + i)).filter(Objects::nonNull).map(UUID::fromString).map(InteractionId::new).collect(Collectors.toList());
    }
}

