/*
 * Decompiled with CFR 0.152.
 */
package org.metamechanists.quaptics.panels.info.implementation;

import java.util.Optional;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.metamechanists.quaptics.connections.ConnectionGroup;
import org.metamechanists.quaptics.items.Lore;
import org.metamechanists.quaptics.panels.info.BlockInfoPanel;
import org.metamechanists.quaptics.panels.info.InfoPanelBuilder;
import org.metamechanists.quaptics.panels.info.InfoPanelContainer;
import org.metamechanists.quaptics.utils.BlockStorageAPI;
import org.metamechanists.quaptics.utils.id.complex.ConnectionGroupId;
import org.metamechanists.quaptics.utils.id.complex.InfoPanelId;

public class CapacitorInfoPanel
extends BlockInfoPanel {
    public CapacitorInfoPanel(@NotNull Location location, ConnectionGroupId groupId) {
        super(location, groupId);
    }

    public CapacitorInfoPanel(@NotNull InfoPanelId panelId, ConnectionGroupId groupId) {
        super(panelId, groupId);
    }

    @Override
    protected InfoPanelContainer buildPanelContainer(@NotNull Location location) {
        return new InfoPanelBuilder(location.clone().toCenterLocation().add(this.getOffset()), 0.4f).addAttribute("chargeBar", false).addAttribute("chargeText", false).build();
    }

    @Override
    public void update() {
        if (this.isPanelHidden()) {
            return;
        }
        Optional<ConnectionGroup> group = this.getGroup();
        if (group.isEmpty()) {
            return;
        }
        Optional<Location> location = group.get().getLocation();
        if (location.isEmpty()) {
            return;
        }
        double capacity = group.get().getBlock().getSettings().getChargeCapacity();
        double charge = BlockStorageAPI.getDouble(location.get(), "QP_CHARGE");
        this.container.setText("chargeText", Lore.chargeBarRaw(charge, capacity));
        this.container.setText("chargeBar", Lore.chargeValuesRaw(charge, capacity));
    }
}

